/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.Mockito;
import org.mockito.internal.verification.api.VerificationMode;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class BasicAuthenticationFilterTests {
    private BasicAuthenticationFilter filter;
    private AuthenticationManager manager;

    private MockHttpServletResponse executeFilterInContainerSimulator(Filter filter, ServletRequest request, boolean expectChainToProceed) throws ServletException, IOException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter(request, (ServletResponse)response, chain);
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)(expectChainToProceed ? Mockito.times((int)1) : Mockito.never()))).doFilter((ServletRequest)Mockito.any(ServletRequest.class), (ServletResponse)Mockito.any(ServletResponse.class));
        return response;
    }

    @Before
    public void setUp() throws Exception {
        SecurityContextHolder.clearContext();
        UsernamePasswordAuthenticationToken rodRequest = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala");
        rodRequest.setDetails((Object)new WebAuthenticationDetails((HttpServletRequest)new MockHttpServletRequest()));
        UsernamePasswordAuthenticationToken rod = new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_1"}));
        this.manager = (AuthenticationManager)Mockito.mock(AuthenticationManager.class);
        Mockito.when((Object)this.manager.authenticate((Authentication)rodRequest)).thenReturn((Object)rod);
        Mockito.when((Object)this.manager.authenticate((Authentication)AdditionalMatchers.not((Object)Mockito.eq((Object)rodRequest)))).thenThrow(new Throwable[]{new BadCredentialsException("")});
        this.filter = new BasicAuthenticationFilter();
        this.filter.setAuthenticationManager(this.manager);
        this.filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)new BasicAuthenticationEntryPoint());
    }

    @After
    public void clearContext() throws Exception {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void testFilterIgnoresRequestsContainingNoAuthorizationHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServletPath("/some_file.html");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testGettersSetters() {
        BasicAuthenticationFilter filter = new BasicAuthenticationFilter();
        filter.setAuthenticationManager(this.manager);
        Assert.assertTrue((filter.getAuthenticationManager() != null ? 1 : 0) != 0);
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class));
        Assert.assertTrue((filter.getAuthenticationEntryPoint() != null ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidBasicAuthorizationTokenIsIgnored() throws Exception {
        String token = "NOT_A_VALID_TOKEN_AS_MISSING_COLON";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testNormalOperation() throws Exception {
        String token = "rod:koala";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"rod", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void testOtherAuthorizationSchemeIsIgnored() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)"SOME_OTHER_AUTHENTICATION_SCHEME");
        request.setServletPath("/some_file.html");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartupDetectsMissingAuthenticationEntryPoint() throws Exception {
        BasicAuthenticationFilter filter = new BasicAuthenticationFilter();
        filter.setAuthenticationManager(this.manager);
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartupDetectsMissingAuthenticationManager() throws Exception {
        BasicAuthenticationFilter filter = new BasicAuthenticationFilter();
        filter.setAuthenticationEntryPoint((AuthenticationEntryPoint)Mockito.mock(AuthenticationEntryPoint.class));
        filter.afterPropertiesSet();
    }

    @Test
    public void testSuccessLoginThenFailureLoginResultsInSessionLosingToken() throws Exception {
        String token = "rod:koala";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"rod", (Object)SecurityContextHolder.getContext().getAuthentication().getName());
        token = "otherUser:WRONG_PASSWORD";
        request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testWrongPasswordContinuesFilterChainIfIgnoreFailureIsTrue() throws Exception {
        String token = "rod:WRONG_PASSWORD";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        this.filter.setIgnoreFailure(true);
        Assert.assertTrue((boolean)this.filter.isIgnoreFailure());
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, true);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testWrongPasswordReturnsForbiddenIfIgnoreFailureIsFalse() throws Exception {
        String token = "rod:WRONG_PASSWORD";
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        request.setServletPath("/some_file.html");
        request.setSession((HttpSession)new MockHttpSession());
        Assert.assertFalse((boolean)this.filter.isIgnoreFailure());
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }
}

