/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.util.Map;
import junit.framework.TestCase;
import org.springframework.security.web.authentication.www.DigestAuthUtils;
import org.springframework.util.StringUtils;

public class DigestAuthUtilsTests
extends TestCase {
    public void testSplitEachArrayElementAndCreateMapNormalOperation() {
        String unsplit = "username=\"rod\", invalidEntryThatHasNoEqualsSign, realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestAuthUtilsTests.assertEquals((String)"rod", (String)((String)headerMap.get("username")));
        DigestAuthUtilsTests.assertEquals((String)"Contacts Realm", (String)((String)headerMap.get("realm")));
        DigestAuthUtilsTests.assertEquals((String)"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==", (String)((String)headerMap.get("nonce")));
        DigestAuthUtilsTests.assertEquals((String)"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4", (String)((String)headerMap.get("uri")));
        DigestAuthUtilsTests.assertEquals((String)"38644211cf9ac3da63ab639807e2baff", (String)((String)headerMap.get("response")));
        DigestAuthUtilsTests.assertEquals((String)"auth", (String)((String)headerMap.get("qop")));
        DigestAuthUtilsTests.assertEquals((String)"00000004", (String)((String)headerMap.get("nc")));
        DigestAuthUtilsTests.assertEquals((String)"2b8d329a8571b99a", (String)((String)headerMap.get("cnonce")));
        DigestAuthUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapRespectsInstructionNotToRemoveCharacters() {
        String unsplit = "username=\"rod\", realm=\"Contacts Realm\", nonce=\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\", uri=\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\", response=\"38644211cf9ac3da63ab639807e2baff\", qop=auth, nc=00000004, cnonce=\"2b8d329a8571b99a\"";
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)unsplit);
        Map headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", null);
        DigestAuthUtilsTests.assertEquals((String)"\"rod\"", (String)((String)headerMap.get("username")));
        DigestAuthUtilsTests.assertEquals((String)"\"Contacts Realm\"", (String)((String)headerMap.get("realm")));
        DigestAuthUtilsTests.assertEquals((String)"\"MTEwOTAyMzU1MTQ4NDo1YzY3OWViYWM5NDNmZWUwM2UwY2NmMDBiNDQzMTQ0OQ==\"", (String)((String)headerMap.get("nonce")));
        DigestAuthUtilsTests.assertEquals((String)"\"/spring-security-sample-contacts-filter/secure/adminPermission.htm?contactId=4\"", (String)((String)headerMap.get("uri")));
        DigestAuthUtilsTests.assertEquals((String)"\"38644211cf9ac3da63ab639807e2baff\"", (String)((String)headerMap.get("response")));
        DigestAuthUtilsTests.assertEquals((String)"auth", (String)((String)headerMap.get("qop")));
        DigestAuthUtilsTests.assertEquals((String)"00000004", (String)((String)headerMap.get("nc")));
        DigestAuthUtilsTests.assertEquals((String)"\"2b8d329a8571b99a\"", (String)((String)headerMap.get("cnonce")));
        DigestAuthUtilsTests.assertEquals((int)8, (int)headerMap.size());
    }

    public void testSplitEachArrayElementAndCreateMapReturnsNullIfArrayEmptyOrNull() {
        DigestAuthUtilsTests.assertNull((Object)DigestAuthUtils.splitEachArrayElementAndCreateMap(null, (String)"=", (String)"\""));
        DigestAuthUtilsTests.assertNull((Object)DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])new String[0], (String)"=", (String)"\""));
    }

    public void testSplitNormalOperation() {
        String unsplit = "username=\"rod==\"";
        DigestAuthUtilsTests.assertEquals((String)"username", (String)DigestAuthUtils.split((String)unsplit, (String)"=")[0]);
        DigestAuthUtilsTests.assertEquals((String)"\"rod==\"", (String)DigestAuthUtils.split((String)unsplit, (String)"=")[1]);
    }

    public void testSplitRejectsNullsAndIncorrectLengthStrings() {
        try {
            DigestAuthUtils.split(null, (String)"=");
            DigestAuthUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthUtilsTests.assertTrue((boolean)true);
        }
        try {
            DigestAuthUtils.split((String)"", (String)"=");
            DigestAuthUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthUtilsTests.assertTrue((boolean)true);
        }
        try {
            DigestAuthUtils.split((String)"sdch=dfgf", null);
            DigestAuthUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthUtilsTests.assertTrue((boolean)true);
        }
        try {
            DigestAuthUtils.split((String)"fvfv=dcdc", (String)"");
            DigestAuthUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthUtilsTests.assertTrue((boolean)true);
        }
        try {
            DigestAuthUtils.split((String)"dfdc=dcdc", (String)"BIGGER_THAN_ONE_CHARACTER");
            DigestAuthUtilsTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthUtilsTests.assertTrue((boolean)true);
        }
    }

    public void testSplitWorksWithDifferentDelimiters() {
        DigestAuthUtilsTests.assertEquals((int)2, (int)DigestAuthUtils.split((String)"18/rod", (String)"/").length);
        DigestAuthUtilsTests.assertNull((Object)DigestAuthUtils.split((String)"18/rod", (String)"!"));
        DigestAuthUtilsTests.assertEquals((int)2, (int)DigestAuthUtils.split((String)"18|rod|foo|bar", (String)"|").length);
    }

    public void testAuthorizationHeaderWithCommasIsSplitCorrectly() {
        String header = "Digest username=\"hamilton,bob\", realm=\"bobs,ok,realm\", nonce=\"the,nonce\", uri=\"the,Uri\", response=\"the,response,Digest\", qop=theqop, nc=thenc, cnonce=\"the,cnonce\"";
        String[] parts = DigestAuthUtils.splitIgnoringQuotes((String)header, (char)',');
        DigestAuthUtilsTests.assertEquals((int)8, (int)parts.length);
    }
}

