/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.DigestAuthUtils;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.NonceExpiredException;
import org.springframework.util.StringUtils;

public class DigestAuthenticationEntryPointTests
extends TestCase {
    private void checkNonceValid(String nonce) {
        DigestAuthenticationEntryPointTests.assertTrue((boolean)Base64.isArrayByteBase64((byte[])nonce.getBytes()));
        String decodedNonce = new String(Base64.decodeBase64((byte[])nonce.getBytes()));
        String[] nonceTokens = StringUtils.delimitedListToStringArray((String)decodedNonce, (String)":");
        DigestAuthenticationEntryPointTests.assertEquals((int)2, (int)nonceTokens.length);
        String expectedNonceSignature = DigestUtils.md5Hex((String)(nonceTokens[0] + ":" + "key"));
        DigestAuthenticationEntryPointTests.assertEquals((String)expectedNonceSignature, (String)nonceTokens[1]);
    }

    public void testDetectsMissingKey() throws Exception {
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        ep.setRealmName("realm");
        try {
            ep.afterPropertiesSet();
            DigestAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthenticationEntryPointTests.assertEquals((String)"key must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingRealmName() throws Exception {
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        ep.setKey("dcdc");
        ep.setNonceValiditySeconds(12);
        try {
            ep.afterPropertiesSet();
            DigestAuthenticationEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DigestAuthenticationEntryPointTests.assertEquals((String)"realmName must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        DigestAuthenticationEntryPointTests.assertEquals((int)300, (int)ep.getNonceValiditySeconds());
        ep.setRealmName("realm");
        DigestAuthenticationEntryPointTests.assertEquals((String)"realm", (String)ep.getRealmName());
        ep.setKey("dcdc");
        DigestAuthenticationEntryPointTests.assertEquals((String)"dcdc", (String)ep.getKey());
        ep.setNonceValiditySeconds(12);
        DigestAuthenticationEntryPointTests.assertEquals((int)12, (int)ep.getNonceValiditySeconds());
    }

    public void testNormalOperation() throws Exception {
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        ep.setRealmName("hello");
        ep.setKey("key");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, (AuthenticationException)new DisabledException("foobar"));
        DigestAuthenticationEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        DigestAuthenticationEntryPointTests.assertEquals((boolean)true, (boolean)response.getHeader("WWW-Authenticate").toString().startsWith("Digest "));
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestAuthenticationEntryPointTests.assertEquals((String)"hello", (String)((String)headerMap.get("realm")));
        DigestAuthenticationEntryPointTests.assertEquals((String)"auth", (String)((String)headerMap.get("qop")));
        DigestAuthenticationEntryPointTests.assertNull(headerMap.get("stale"));
        this.checkNonceValid((String)headerMap.get("nonce"));
    }

    public void testOperationIfDueToStaleNonce() throws Exception {
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        ep.setRealmName("hello");
        ep.setKey("key");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.afterPropertiesSet();
        ep.commence((HttpServletRequest)request, (HttpServletResponse)response, (AuthenticationException)new NonceExpiredException("expired nonce"));
        DigestAuthenticationEntryPointTests.assertEquals((int)401, (int)response.getStatus());
        DigestAuthenticationEntryPointTests.assertTrue((boolean)response.getHeader("WWW-Authenticate").toString().startsWith("Digest "));
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        DigestAuthenticationEntryPointTests.assertEquals((String)"hello", (String)((String)headerMap.get("realm")));
        DigestAuthenticationEntryPointTests.assertEquals((String)"auth", (String)((String)headerMap.get("qop")));
        DigestAuthenticationEntryPointTests.assertEquals((String)"true", (String)((String)headerMap.get("stale")));
        this.checkNonceValid((String)headerMap.get("nonce"));
    }
}

