/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.www;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.cache.NullUserCache;
import org.springframework.security.core.userdetails.memory.InMemoryDaoImpl;
import org.springframework.security.core.userdetails.memory.UserMap;
import org.springframework.security.core.userdetails.memory.UserMapEditor;
import org.springframework.security.web.authentication.www.DigestAuthUtils;
import org.springframework.security.web.authentication.www.DigestAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.DigestAuthenticationFilter;
import org.springframework.util.StringUtils;

public class DigestAuthenticationFilterTests {
    private static final String NC = "00000002";
    private static final String CNONCE = "c822c727a648aba7";
    private static final String REALM = "The Actual, Correct Realm Name";
    private static final String KEY = "springsecurity";
    private static final String QOP = "auth";
    private static final String USERNAME = "rod,ok";
    private static final String PASSWORD = "koala";
    private static final String REQUEST_URI = "/some_file.html";
    private static final String NONCE = DigestAuthenticationFilterTests.generateNonce(60);
    private DigestAuthenticationFilter filter;
    private MockHttpServletRequest request;

    private String createAuthorizationHeader(String username, String realm, String nonce, String uri, String responseDigest, String qop, String nc, String cnonce) {
        return "Digest username=\"" + username + "\", realm=\"" + realm + "\", nonce=\"" + nonce + "\", uri=\"" + uri + "\", response=\"" + responseDigest + "\", qop=" + qop + ", nc=" + nc + ", cnonce=\"" + cnonce + "\"";
    }

    private MockHttpServletResponse executeFilterInContainerSimulator(Filter filter, final ServletRequest request, final boolean expectChainToProceed) throws ServletException, IOException {
        final MockHttpServletResponse response = new MockHttpServletResponse();
        JUnit4Mockery jmockContext = new JUnit4Mockery();
        final FilterChain chain = (FilterChain)jmockContext.mock(FilterChain.class);
        jmockContext.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterChain)this.exactly(expectChainToProceed ? 1 : 0).of((Object)chain)).doFilter(request, (ServletResponse)response);
            }
        });
        filter.doFilter(request, (ServletResponse)response, chain);
        jmockContext.assertIsSatisfied();
        return response;
    }

    private static String generateNonce(int validitySeconds) {
        long expiryTime = System.currentTimeMillis() + (long)(validitySeconds * 1000);
        String signatureValue = new String(DigestUtils.md5Hex((String)(expiryTime + ":" + KEY)));
        String nonceValue = expiryTime + ":" + signatureValue;
        return new String(Base64.encodeBase64((byte[])nonceValue.getBytes()));
    }

    @After
    public void clearContext() throws Exception {
        SecurityContextHolder.clearContext();
    }

    @Before
    public void setUp() throws Exception {
        SecurityContextHolder.clearContext();
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("rod,ok=koala,ROLE_ONE,ROLE_TWO,enabled\r\n");
        dao.setUserMap((UserMap)editor.getValue());
        DigestAuthenticationEntryPoint ep = new DigestAuthenticationEntryPoint();
        ep.setRealmName(REALM);
        ep.setKey(KEY);
        this.filter = new DigestAuthenticationFilter();
        this.filter.setUserDetailsService((UserDetailsService)dao);
        this.filter.setAuthenticationEntryPoint(ep);
        this.request = new MockHttpServletRequest("GET", REQUEST_URI);
        this.request.setServletPath(REQUEST_URI);
    }

    @Test
    public void testExpiredNonceReturnsForbiddenWithStaleHeader() throws Exception {
        String nonce = DigestAuthenticationFilterTests.generateNonce(0);
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        Thread.sleep(1000L);
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String header = response.getHeader("WWW-Authenticate").toString().substring(7);
        String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)header);
        Map headerMap = DigestAuthUtils.splitEachArrayElementAndCreateMap((String[])headerEntries, (String)"=", (String)"\"");
        Assert.assertEquals((Object)"true", headerMap.get("stale"));
    }

    @Test
    public void testFilterIgnoresRequestsContainingNoAuthorizationHeader() throws Exception {
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testGettersSetters() {
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setUserDetailsService((UserDetailsService)new InMemoryDaoImpl());
        Assert.assertTrue((filter.getUserDetailsService() != null ? 1 : 0) != 0);
        filter.setAuthenticationEntryPoint(new DigestAuthenticationEntryPoint());
        Assert.assertTrue((filter.getAuthenticationEntryPoint() != null ? 1 : 0) != 0);
        filter.setUserCache(null);
        Assert.assertNull((Object)filter.getUserCache());
        filter.setUserCache((UserCache)new NullUserCache());
        Assert.assertNotNull((Object)filter.getUserCache());
    }

    @Test
    public void testInvalidDigestAuthorizationTokenGeneratesError() throws Exception {
        String token = "NOT_A_VALID_TOKEN_AS_MISSING_COLON";
        this.request.addHeader("Authorization", (Object)("Digest " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testMalformedHeaderReturnsForbidden() throws Exception {
        this.request.addHeader("Authorization", (Object)"Digest scsdcsdc");
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testNonBase64EncodedNonceReturnsForbidden() throws Exception {
        String nonce = "NOT_BASE_64_ENCODED";
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testNonceWithIncorrectSignatureForNumericFieldReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"123456:incorrectStringPassword".getBytes()));
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testNonceWithNonNumericFirstElementReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"hello:ignoredSecondElement".getBytes()));
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testNonceWithoutTwoColonSeparatedElementsReturnsForbidden() throws Exception {
        String nonce = new String(Base64.encodeBase64((byte[])"a base 64 string without a colon".getBytes()));
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)nonce, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, nonce, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void testNormalOperationWhenPasswordIsAlreadyEncoded() throws Exception {
        String encodedPassword = DigestAuthUtils.encodePasswordInA1Format((String)USERNAME, (String)REALM, (String)PASSWORD);
        String responseDigest = DigestAuthUtils.generateDigest((boolean)true, (String)USERNAME, (String)REALM, (String)encodedPassword, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)USERNAME, (Object)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
    }

    @Test
    public void testNormalOperationWhenPasswordNotAlreadyEncoded() throws Exception {
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)USERNAME, (Object)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
        Assert.assertFalse((boolean)SecurityContextHolder.getContext().getAuthentication().isAuthenticated());
    }

    @Test
    public void testNormalOperationWhenPasswordNotAlreadyEncodedAndWithoutReAuthentication() throws Exception {
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.filter.setCreateAuthenticatedToken(true);
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)USERNAME, (Object)((UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUsername());
        Assert.assertTrue((boolean)SecurityContextHolder.getContext().getAuthentication().isAuthenticated());
        Assert.assertEquals((Object)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_ONE", "ROLE_TWO"}), (Object)SecurityContextHolder.getContext().getAuthentication().getAuthorities());
    }

    @Test
    public void otherAuthorizationSchemeIsIgnored() throws Exception {
        this.request.addHeader("Authorization", (Object)"SOME_OTHER_AUTHENTICATION_SCHEME");
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test(expected=IllegalArgumentException.class)
    public void startupDetectsMissingAuthenticationEntryPoint() throws Exception {
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setUserDetailsService((UserDetailsService)new InMemoryDaoImpl());
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void startupDetectsMissingUserDetailsService() throws Exception {
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setAuthenticationEntryPoint(new DigestAuthenticationEntryPoint());
        filter.afterPropertiesSet();
    }

    @Test
    public void successfulLoginThenFailedLoginResultsInSessionLosingToken() throws Exception {
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, true);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)"WRONG_PASSWORD", (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request = new MockHttpServletRequest();
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void wrongCnonceBasedOnDigestReturnsForbidden() throws Exception {
        String cnonce = "NOT_SAME_AS_USED_FOR_DIGEST_COMPUTATION";
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)"DIFFERENT_CNONCE");
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, cnonce));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void wrongDigestReturnsForbidden() throws Exception {
        String password = "WRONG_PASSWORD";
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)REALM, (String)password, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void wrongRealmReturnsForbidden() throws Exception {
        String realm = "WRONG_REALM";
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)USERNAME, (String)realm, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, realm, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }

    @Test
    public void wrongUsernameReturnsForbidden() throws Exception {
        String responseDigest = DigestAuthUtils.generateDigest((boolean)false, (String)"NOT_A_KNOWN_USER", (String)REALM, (String)PASSWORD, (String)"GET", (String)REQUEST_URI, (String)QOP, (String)NONCE, (String)NC, (String)CNONCE);
        this.request.addHeader("Authorization", (Object)this.createAuthorizationHeader(USERNAME, REALM, NONCE, REQUEST_URI, responseDigest, QOP, NC, CNONCE));
        MockHttpServletResponse response = this.executeFilterInContainerSimulator((Filter)this.filter, (ServletRequest)this.request, false);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)401L, (long)response.getStatus());
    }
}

