/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.concurrent;

import java.util.Date;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.session.ConcurrentSessionFilter;

public class ConcurrentSessionFilterTests {
    @Test
    public void detectsExpiredSessions() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        filter.setLogoutHandlers(new LogoutHandler[]{new SecurityContextLogoutHandler()});
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        registry.getSessionInformation(session.getId()).expireNow();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        filter.afterPropertiesSet();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Mockito.verifyZeroInteractions((Object[])new Object[]{fc});
        Assert.assertEquals((Object)"/expired.jsp", (Object)response.getRedirectedUrl());
    }

    @Test
    public void returnsExpectedMessageWhenNoExpiredUrlSet() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        registry.getSessionInformation(session.getId()).expireNow();
        filter.setSessionRegistry((SessionRegistry)registry);
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Mockito.verifyZeroInteractions((Object[])new Object[]{fc});
        Assert.assertEquals((Object)"This session has been expired (possibly due to multiple concurrent logins being attempted as the same user).", (Object)response.getContentAsString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsMissingSessionRegistry() throws Exception {
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.afterPropertiesSet();
    }

    @Test(expected=IllegalArgumentException.class)
    public void detectsInvalidUrl() throws Exception {
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.setExpiredUrl("ImNotValid");
        filter.afterPropertiesSet();
    }

    @Test
    public void lastRequestTimeUpdatesCorrectly() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        Date lastRequest = registry.getSessionInformation(session.getId()).getLastRequest();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        Thread.sleep(1000L);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        ((FilterChain)Mockito.verify((Object)fc)).doFilter((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)registry.getSessionInformation(session.getId()).getLastRequest().after(lastRequest));
    }
}

