/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockFilterConfig;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpSessionContextIntegrationFilter;

public class HttpSessionContextIntegrationFilterTests {
    private UsernamePasswordAuthenticationToken sessionPrincipal = new UsernamePasswordAuthenticationToken((Object)"someone", (Object)"password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"SOME_ROLE"}));

    private static void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.doFilter(request, response, filterChain);
    }

    @Test
    public void testDetectsIncompatibleSessionProperties() throws Exception {
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        try {
            filter.setAllowSessionCreation(false);
            filter.setForceEagerSessionCreation(true);
            filter.afterPropertiesSet();
            Assert.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)true);
        }
        filter.setAllowSessionCreation(true);
        filter.afterPropertiesSet();
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testDetectsMissingOrInvalidContext() throws Exception {
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        try {
            filter.setContextClass(null);
            filter.afterPropertiesSet();
            Assert.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)true);
        }
        try {
            filter.setContextClass(Integer.class);
            Assert.assertEquals(Integer.class, (Object)filter.getContextClass());
            filter.afterPropertiesSet();
            Assert.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testExceptionWithinFilterChainStillClearsSecurityContextHolder() throws Exception {
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)this.sessionPrincipal);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)sc);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain((Authentication)this.sessionPrincipal, null, new IOException());
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        filter.afterPropertiesSet();
        try {
            HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
            Assert.fail((String)"We should have received the IOException thrown inside the filter chain here");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)true);
        }
        Assert.assertEquals((Object)new SecurityContextImpl(), (Object)SecurityContextHolder.getContext());
        Assert.assertNull((String)"Should have cleared FILTER_APPLIED", (Object)request.getAttribute("__spring_security_scpf_applied"));
    }

    @Test
    public void testExistingContextContentsCopiedIntoContextHolderFromSessionAndChangesToContextCopiedBackToSession() throws Exception {
        UsernamePasswordAuthenticationToken updatedPrincipal = new UsernamePasswordAuthenticationToken((Object)"someone", (Object)"password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"SOME_DIFFERENT_ROLE"}));
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)this.sessionPrincipal);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)sc);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain((Authentication)this.sessionPrincipal, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    @Test
    public void testHttpSessionCreatedWhenContextHolderChanges() throws Exception {
        UsernamePasswordAuthenticationToken updatedPrincipal = new UsernamePasswordAuthenticationToken((Object)"someone", (Object)"password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"SOME_ROLE"}));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession(false).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    @Test
    public void testHttpSessionEagerlyCreatedWhenDirected() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, null, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        filter.setForceEagerSessionCreation(true);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertNotNull((Object)request.getSession(false));
    }

    @Test
    public void testHttpSessionNotCreatedUnlessContextHolderChanges() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, null, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void testHttpSessionWithNonContextInWellKnownLocationIsOverwritten() throws Exception {
        UsernamePasswordAuthenticationToken updatedPrincipal = new UsernamePasswordAuthenticationToken((Object)"someone", (Object)"password", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"SOME_DIFFERENT_ROLE"}));
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)"NOT_A_CONTEXT_OBJECT");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContextClass(SecurityContextImpl.class);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    private class MockFilterChain
    implements FilterChain {
        private Authentication changeContextHolder;
        private Authentication expectedOnContextHolder;
        private IOException toThrowDuringChain;

        public MockFilterChain(Authentication expectedOnContextHolder, Authentication changeContextHolder, IOException toThrowDuringChain) {
            this.expectedOnContextHolder = expectedOnContextHolder;
            this.changeContextHolder = changeContextHolder;
            this.toThrowDuringChain = toThrowDuringChain;
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            if (this.expectedOnContextHolder != null) {
                Assert.assertEquals((Object)this.expectedOnContextHolder, (Object)SecurityContextHolder.getContext().getAuthentication());
            }
            if (this.changeContextHolder != null) {
                SecurityContext sc = SecurityContextHolder.getContext();
                sc.setAuthentication(this.changeContextHolder);
                SecurityContextHolder.setContext((SecurityContext)sc);
            }
            if (this.toThrowDuringChain != null) {
                throw this.toThrowDuringChain;
            }
        }
    }
}

