/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SaveContextOnUpdateOrErrorResponseWrapper;

public class HttpSessionSecurityContextRepositoryTests {
    private final TestingAuthenticationToken testToken = new TestingAuthenticationToken((Object)"someone", (Object)"passwd", new String[]{"ROLE_A"});

    @Test(expected=IllegalArgumentException.class)
    @Deprecated
    public void detectsInvalidContextClass() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        repo.setSecurityContextClass(String.class);
    }

    @Deprecated
    @Test(expected=IllegalArgumentException.class)
    public void cannotSetNullContextClass() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        repo.setSecurityContextClass(null);
    }

    @Test
    public void sessionIsntCreatedIfContextDoesntChange() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext context = repo.loadContext(holder);
        Assert.assertNull((Object)request.getSession(false));
        repo.saveContext(context, holder.getRequest(), holder.getResponse());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void sessionIsntCreatedIfAllowSessionCreationIsFalse() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        repo.setAllowSessionCreation(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext context = repo.loadContext(holder);
        context.setAuthentication((Authentication)this.testToken);
        repo.saveContext(context, holder.getRequest(), holder.getResponse());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void existingContextIsSuccessFullyLoadedFromSessionAndSavedBack() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)SecurityContextHolder.getContext());
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext context = repo.loadContext(holder);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((Object)this.testToken, (Object)context.getAuthentication());
        repo.saveContext(context, holder.getRequest(), holder.getResponse());
        Assert.assertEquals((Object)context, (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
    }

    @Test
    public void nonSecurityContextInSessionIsIgnored() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)"NotASecurityContextInstance");
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext context = repo.loadContext(holder);
        Assert.assertNotNull((Object)context);
        Assert.assertNull((Object)context.getAuthentication());
    }

    @Test
    public void sessionIsCreatedAndContextStoredWhenContextChanges() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext context = repo.loadContext(holder);
        Assert.assertNull((Object)request.getSession(false));
        context.setAuthentication((Authentication)this.testToken);
        repo.saveContext(context, holder.getRequest(), holder.getResponse());
        Assert.assertNotNull((Object)request.getSession(false));
        Assert.assertEquals((Object)context, (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
    }

    @Test
    public void redirectCausesEarlySaveOfContext() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContextHolder.setContext((SecurityContext)repo.loadContext(holder));
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        holder.getResponse().sendRedirect("/doesntmatter");
        Assert.assertEquals((Object)SecurityContextHolder.getContext(), (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
        Assert.assertTrue((boolean)((SaveContextOnUpdateOrErrorResponseWrapper)holder.getResponse()).isContextSaved());
        repo.saveContext(SecurityContextHolder.getContext(), holder.getRequest(), holder.getResponse());
        Assert.assertEquals((Object)SecurityContextHolder.getContext(), (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
    }

    @Test
    public void sendErrorCausesEarlySaveOfContext() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContextHolder.setContext((SecurityContext)repo.loadContext(holder));
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        holder.getResponse().sendError(404);
        Assert.assertEquals((Object)SecurityContextHolder.getContext(), (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
        Assert.assertTrue((boolean)((SaveContextOnUpdateOrErrorResponseWrapper)holder.getResponse()).isContextSaved());
        repo.saveContext(SecurityContextHolder.getContext(), holder.getRequest(), holder.getResponse());
        Assert.assertEquals((Object)SecurityContextHolder.getContext(), (Object)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT"));
    }

    @Test
    public void noSessionIsCreatedIfSessionWasInvalidatedDuringTheRequest() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContextHolder.setContext((SecurityContext)repo.loadContext(holder));
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        request.getSession().invalidate();
        repo.saveContext(SecurityContextHolder.getContext(), holder.getRequest(), holder.getResponse());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void noSessionIsCreatedIfAnonymousTokenIsUsed() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContextHolder.setContext((SecurityContext)repo.loadContext(holder));
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnonymousAuthenticationToken("key", (Object)"anon", AuthorityUtils.createAuthorityList((String[])new String[]{"ANON"})));
        repo.saveContext(SecurityContextHolder.getContext(), holder.getRequest(), holder.getResponse());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    @Deprecated
    public void settingCloneFromContextLoadsClonedContextObject() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        repo.setCloneFromHttpSession(true);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockContext contextBefore = new MockContext();
        request.getSession().setAttribute("SPRING_SECURITY_CONTEXT", (Object)contextBefore);
        contextBefore.setAuthentication((Authentication)this.testToken);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        SecurityContext loadedContext = repo.loadContext(holder);
        Assert.assertTrue((boolean)(loadedContext instanceof MockContext));
        Assert.assertFalse((loadedContext == contextBefore ? 1 : 0) != 0);
    }

    @Test
    @Deprecated
    public void generateNewContextWorksWithContextClass() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        repo.setSecurityContextClass(MockContext.class);
        Assert.assertTrue((boolean)(repo.generateNewContext() instanceof MockContext));
    }

    @Test
    public void sessionDisableUrlRewritingPreventsSessionIdBeingWrittenToUrl() throws Exception {
        HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = ";jsessionid=id";
        MockHttpServletResponse response = new MockHttpServletResponse(){

            public String encodeRedirectUrl(String url) {
                return url + ";jsessionid=id";
            }

            public String encodeRedirectURL(String url) {
                return url + ";jsessionid=id";
            }

            public String encodeUrl(String url) {
                return url + ";jsessionid=id";
            }

            public String encodeURL(String url) {
                return url + ";jsessionid=id";
            }
        };
        HttpRequestResponseHolder holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        repo.loadContext(holder);
        String url = "/aUrl";
        Assert.assertEquals((Object)(url + ";jsessionid=id"), (Object)holder.getResponse().encodeRedirectUrl(url));
        Assert.assertEquals((Object)(url + ";jsessionid=id"), (Object)holder.getResponse().encodeRedirectURL(url));
        Assert.assertEquals((Object)(url + ";jsessionid=id"), (Object)holder.getResponse().encodeUrl(url));
        Assert.assertEquals((Object)(url + ";jsessionid=id"), (Object)holder.getResponse().encodeURL(url));
        repo.setDisableUrlRewriting(true);
        holder = new HttpRequestResponseHolder((HttpServletRequest)request, (HttpServletResponse)response);
        repo.loadContext(holder);
        Assert.assertEquals((Object)url, (Object)holder.getResponse().encodeRedirectUrl(url));
        Assert.assertEquals((Object)url, (Object)holder.getResponse().encodeRedirectURL(url));
        Assert.assertEquals((Object)url, (Object)holder.getResponse().encodeUrl(url));
        Assert.assertEquals((Object)url, (Object)holder.getResponse().encodeURL(url));
    }

    static class MockContext
    implements Cloneable,
    SecurityContext {
        Authentication a;

        MockContext() {
        }

        public Authentication getAuthentication() {
            return this.a;
        }

        public void setAuthentication(Authentication authentication) {
            this.a = authentication;
        }

        public Object clone() {
            MockContext mc = new MockContext();
            mc.setAuthentication(this.getAuthentication());
            return mc;
        }
    }
}

