/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.SecurityContextRepository;

public class SecurityContextPersistenceFilterTests {
    Mockery jmock = new JUnit4Mockery();
    TestingAuthenticationToken testToken = new TestingAuthenticationToken((Object)"someone", (Object)"passwd", new String[]{"ROLE_A"});

    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void contextIsClearedAfterChainProceeds() throws Exception {
        final FilterChain chain = (FilterChain)this.jmock.mock(FilterChain.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter();
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterChain)this.oneOf(chain)).doFilter((ServletRequest)this.with(1.aNonNull(HttpServletRequest.class)), (ServletResponse)this.with(1.aNonNull(HttpServletResponse.class)));
            }
        });
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void contextIsStillClearedIfExceptionIsThrowByFilterChain() throws Exception {
        final FilterChain chain = (FilterChain)this.jmock.mock(FilterChain.class);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter();
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.testToken);
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterChain)this.oneOf(chain)).doFilter((ServletRequest)this.with(2.aNonNull(HttpServletRequest.class)), (ServletResponse)this.with(2.aNonNull(HttpServletResponse.class)));
                this.will(2.throwException((Throwable)new IOException()));
            }
        });
        try {
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void loadedContextContextIsCopiedToSecurityContextHolderAndUpdatedContextIsStored() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter();
        final TestingAuthenticationToken beforeAuth = new TestingAuthenticationToken((Object)"someoneelse", (Object)"passwd", new String[]{"ROLE_B"});
        SecurityContextImpl scBefore = new SecurityContextImpl();
        SecurityContextImpl scExpectedAfter = new SecurityContextImpl();
        scExpectedAfter.setAuthentication((Authentication)this.testToken);
        scBefore.setAuthentication((Authentication)beforeAuth);
        final SecurityContextRepository repo = (SecurityContextRepository)this.jmock.mock(SecurityContextRepository.class);
        filter.setSecurityContextRepository(repo);
        this.jmock.checking((ExpectationBuilder)new Expectations((SecurityContext)scBefore, (SecurityContext)scExpectedAfter, request, response){
            final /* synthetic */ SecurityContext val$scBefore;
            final /* synthetic */ SecurityContext val$scExpectedAfter;
            final /* synthetic */ MockHttpServletRequest val$request;
            final /* synthetic */ MockHttpServletResponse val$response;
            {
                this.val$scBefore = securityContext;
                this.val$scExpectedAfter = securityContext2;
                this.val$request = mockHttpServletRequest;
                this.val$response = mockHttpServletResponse;
                ((SecurityContextRepository)this.oneOf(repo)).loadContext((HttpRequestResponseHolder)this.with(3.aNonNull(HttpRequestResponseHolder.class)));
                this.will(3.returnValue((Object)this.val$scBefore));
                ((SecurityContextRepository)this.oneOf(repo)).saveContext(this.val$scExpectedAfter, (HttpServletRequest)this.val$request, (HttpServletResponse)this.val$response);
            }
        });
        FilterChain chain = new FilterChain((SecurityContext)scExpectedAfter){
            final /* synthetic */ SecurityContext val$scExpectedAfter;
            {
                this.val$scExpectedAfter = securityContext;
            }

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                Assert.assertEquals((Object)beforeAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
                SecurityContextHolder.setContext((SecurityContext)this.val$scExpectedAfter);
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        this.jmock.assertIsSatisfied();
    }

    @Test
    public void filterIsNotAppliedAgainIfFilterAppliedAttributeIsSet() throws Exception {
        final FilterChain chain = (FilterChain)this.jmock.mock(FilterChain.class);
        final MockHttpServletRequest request = new MockHttpServletRequest();
        final MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter();
        filter.setSecurityContextRepository((SecurityContextRepository)this.jmock.mock(SecurityContextRepository.class));
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterChain)this.oneOf(chain)).doFilter((ServletRequest)request, (ServletResponse)response);
            }
        });
        request.setAttribute("__spring_security_scpf_applied", (Object)Boolean.TRUE);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        this.jmock.assertIsSatisfied();
    }

    @Test
    public void sessionIsEagerlyCreatedWhenConfigured() throws Exception {
        final FilterChain chain = (FilterChain)this.jmock.mock(FilterChain.class);
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(chain);
            }
        });
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SecurityContextPersistenceFilter filter = new SecurityContextPersistenceFilter();
        filter.setForceEagerSessionCreation(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        Assert.assertNotNull((Object)request.getSession(false));
    }
}

