/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.firewall;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.RequestRejectedException;

public class DefaultHttpFirewallTests {
    public String[] unnormalizedPaths = new String[]{"/..", "/./path/", "/path/path/.", "/path/path//.", "./path/../path//.", "./path", ".//path", "."};

    @Test
    public void unnormalizedPathsAreRejected() throws Exception {
        DefaultHttpFirewall fw = new DefaultHttpFirewall();
        for (String path : this.unnormalizedPaths) {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setServletPath(path);
            try {
                fw.getFirewalledRequest((HttpServletRequest)request);
                Assert.fail((String)(path + " is un-normalized"));
            }
            catch (RequestRejectedException expected) {
                // empty catch block
            }
            request.setPathInfo(path);
            try {
                fw.getFirewalledRequest((HttpServletRequest)request);
                Assert.fail((String)(path + " is un-normalized"));
            }
            catch (RequestRejectedException expected) {
                // empty catch block
            }
        }
    }
}

