/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.MockPortResolver;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;

public class DefaultSavedRequestTests {
    @Test
    public void headersAreCaseInsensitive() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("USER-aGenT", (Object)"Mozilla");
        DefaultSavedRequest saved = new DefaultSavedRequest((HttpServletRequest)request, (PortResolver)new MockPortResolver(8080, 8443));
        Assert.assertEquals((Object)"Mozilla", saved.getHeaderValues("user-agent").get(0));
    }

    @Test
    public void discardsIfNoneMatchHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("If-None-Match", (Object)"somehashvalue");
        DefaultSavedRequest saved = new DefaultSavedRequest((HttpServletRequest)request, (PortResolver)new MockPortResolver(8080, 8443));
        Assert.assertTrue((boolean)saved.getHeaderValues("if-none-match").isEmpty());
    }

    @Test
    public void parametersAreCaseInsensitive() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("ThisIsATest", "Hi mom");
        DefaultSavedRequest saved = new DefaultSavedRequest((HttpServletRequest)request, (PortResolver)new MockPortResolver(8080, 8443));
        Assert.assertEquals((Object)"Hi mom", (Object)saved.getParameterValues("thisisatest")[0]);
    }
}

