/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;

public class HttpSessionRequestCacheTests {
    @Test
    public void originalGetRequestDoesntMatchIncomingPost() {
        HttpSessionRequestCache cache = new HttpSessionRequestCache();
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "/destination");
        MockHttpServletResponse response = new MockHttpServletResponse();
        cache.saveRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNotNull((Object)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY"));
        Assert.assertNotNull((Object)cache.getRequest((HttpServletRequest)request, (HttpServletResponse)response));
        MockHttpServletRequest newRequest = new MockHttpServletRequest("POST", "/destination");
        newRequest.setSession(request.getSession());
        Assert.assertNull((Object)cache.getMatchingRequest((HttpServletRequest)newRequest, (HttpServletResponse)response));
    }
}

