/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;

public class RequestCacheAwareFilterTests {
    @Test
    public void savedRequestIsRemovedAfterMatch() throws Exception {
        RequestCacheAwareFilter filter = new RequestCacheAwareFilter();
        HttpSessionRequestCache cache = new HttpSessionRequestCache();
        MockHttpServletRequest request = new MockHttpServletRequest("POST", "/destination");
        MockHttpServletResponse response = new MockHttpServletResponse();
        cache.saveRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertNotNull((Object)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY"));
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY"));
    }
}

