/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.savedrequest;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.savedrequest.FastHttpDateFormat;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.savedrequest.SavedRequestAwareWrapper;

public class SavedRequestAwareWrapperTests {
    private SavedRequestAwareWrapper createWrapper(MockHttpServletRequest requestToSave, MockHttpServletRequest requestToWrap) {
        DefaultSavedRequest saved = new DefaultSavedRequest((HttpServletRequest)requestToSave, (PortResolver)new PortResolverImpl());
        return new SavedRequestAwareWrapper((SavedRequest)saved, (HttpServletRequest)requestToWrap);
    }

    @Test
    public void savedRequestCookiesAreReturnedIfSavedRequestIsSet() throws Exception {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.setCookies(new Cookie[]{new Cookie("cookie", "fromsaved")});
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, new MockHttpServletRequest());
        Assert.assertEquals((long)1L, (long)wrapper.getCookies().length);
        Assert.assertEquals((Object)"fromsaved", (Object)wrapper.getCookies()[0].getValue());
    }

    @Test
    public void savedRequesthHeaderIsReturnedIfSavedRequestIsSet() throws Exception {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.addHeader("header", (Object)"savedheader");
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, new MockHttpServletRequest());
        Assert.assertNull((Object)wrapper.getHeader("nonexistent"));
        Enumeration headers = wrapper.getHeaders("nonexistent");
        Assert.assertFalse((boolean)headers.hasMoreElements());
        Assert.assertEquals((Object)"savedheader", (Object)wrapper.getHeader("Header"));
        headers = wrapper.getHeaders("heaDer");
        Assert.assertTrue((boolean)headers.hasMoreElements());
        Assert.assertEquals((Object)"savedheader", headers.nextElement());
        Assert.assertFalse((boolean)headers.hasMoreElements());
        Assert.assertTrue((boolean)wrapper.getHeaderNames().hasMoreElements());
        Assert.assertEquals((Object)"header", wrapper.getHeaderNames().nextElement());
    }

    @Test
    public void wrappedRequestParameterTakesPrecedenceOverSavedRequest() {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.setParameter("action", "foo");
        MockHttpServletRequest wrappedRequest = new MockHttpServletRequest();
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, wrappedRequest);
        Assert.assertEquals((Object)"foo", (Object)wrapper.getParameter("action"));
        wrappedRequest.setParameter("action", "bar");
        Assert.assertEquals((Object)"bar", (Object)wrapper.getParameter("action"));
        Assert.assertEquals((long)2L, (long)wrapper.getParameterValues("action").length);
        Assert.assertEquals((Object)"bar", (Object)wrapper.getParameterValues("action")[0]);
    }

    @Test
    public void savedRequestDoesntCreateDuplicateParams() {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.setParameter("action", "foo");
        MockHttpServletRequest wrappedRequest = new MockHttpServletRequest();
        wrappedRequest.setParameter("action", "foo");
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, wrappedRequest);
        Assert.assertEquals((long)1L, (long)wrapper.getParameterValues("action").length);
        Assert.assertEquals((long)1L, (long)wrapper.getParameterMap().size());
        Assert.assertEquals((long)1L, (long)((String[])wrapper.getParameterMap().get("action")).length);
    }

    @Test
    public void savedRequestHeadersTakePrecedence() {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.addHeader("Authorization", (Object)"foo");
        MockHttpServletRequest wrappedRequest = new MockHttpServletRequest();
        wrappedRequest.addHeader("Authorization", (Object)"bar");
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, wrappedRequest);
        Assert.assertEquals((Object)"foo", (Object)wrapper.getHeader("Authorization"));
    }

    @Test
    public void getParameterValuesReturnsNullIfParameterIsntSet() {
        SavedRequestAwareWrapper wrapper = this.createWrapper(new MockHttpServletRequest(), new MockHttpServletRequest());
        Assert.assertNull((Object)wrapper.getParameterValues("action"));
        Assert.assertNull(wrapper.getParameterMap().get("action"));
    }

    @Test
    public void getParameterValuesReturnsCombinedSavedAndWrappedRequestValues() {
        MockHttpServletRequest savedRequest = new MockHttpServletRequest();
        savedRequest.setParameter("action", "foo");
        MockHttpServletRequest wrappedRequest = new MockHttpServletRequest();
        SavedRequestAwareWrapper wrapper = this.createWrapper(savedRequest, wrappedRequest);
        Assert.assertArrayEquals((Object[])new Object[]{"foo"}, (Object[])wrapper.getParameterValues("action"));
        wrappedRequest.setParameter("action", "bar");
        Assert.assertArrayEquals((Object[])new Object[]{"bar", "foo"}, (Object[])wrapper.getParameterValues("action"));
        String[] valuesFromMap = (String[])wrapper.getParameterMap().get("action");
        Assert.assertEquals((long)2L, (long)valuesFromMap.length);
        Assert.assertEquals((Object)"bar", (Object)valuesFromMap[0]);
    }

    @Test
    public void expecteDateHeaderIsReturnedFromSavedRequest() throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        String nowString = FastHttpDateFormat.getCurrentDate();
        Date now = formatter.parse(nowString);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("header", (Object)nowString);
        SavedRequestAwareWrapper wrapper = this.createWrapper(request, new MockHttpServletRequest());
        Assert.assertEquals((long)now.getTime(), (long)wrapper.getDateHeader("header"));
        Assert.assertEquals((long)-1L, (long)wrapper.getDateHeader("nonexistent"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidDateHeaderIsRejected() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("header", (Object)"notadate");
        SavedRequestAwareWrapper wrapper = this.createWrapper(request, new MockHttpServletRequest());
        wrapper.getDateHeader("header");
    }

    @Test
    public void correctHttpMethodIsReturned() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("PUT", "/notused");
        SavedRequestAwareWrapper wrapper = this.createWrapper(request, new MockHttpServletRequest("GET", "/notused"));
        Assert.assertEquals((Object)"PUT", (Object)wrapper.getMethod());
    }

    @Test
    public void correctIntHeaderIsReturned() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("header", (Object)"999");
        request.addHeader("header", (Object)"1000");
        SavedRequestAwareWrapper wrapper = this.createWrapper(request, new MockHttpServletRequest());
        Assert.assertEquals((long)999L, (long)wrapper.getIntHeader("header"));
        Assert.assertEquals((long)-1L, (long)wrapper.getIntHeader("nonexistent"));
    }
}

