/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servletapi;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class SecurityContextHolderAwareRequestFilterTests {
    Mockery jmock = new JUnit4Mockery();

    @Test
    public void expectedRequestWrapperClassIsUsed() throws Exception {
        SecurityContextHolderAwareRequestFilter filter = new SecurityContextHolderAwareRequestFilter();
        filter.setRolePrefix("ROLE_");
        final FilterChain filterChain = (FilterChain)this.jmock.mock(FilterChain.class);
        this.jmock.checking((ExpectationBuilder)new Expectations(){
            {
                ((FilterChain)this.exactly(2).of((Object)filterChain)).doFilter((ServletRequest)this.with(1.aNonNull(SecurityContextHolderAwareRequestWrapper.class)), (ServletResponse)this.with(1.aNonNull(HttpServletResponse.class)));
            }
        });
        filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), filterChain);
        filter.doFilter((ServletRequest)new MockHttpServletRequest(), (ServletResponse)new MockHttpServletResponse(), filterChain);
        filter.destroy();
    }
}

