/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.servletapi;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class SecurityContextHolderAwareRequestWrapperTests
extends TestCase {
    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testCorrectOperationWithStringBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"rod", (Object)"koala", new String[]{"ROLE_FOO"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, "");
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"rod", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)auth, (Object)wrapper.getUserPrincipal());
    }

    public void testUseOfRolePrefixMeansItIsntNeededWhenCallngIsUserInRole() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"rod", (Object)"koala", new String[]{"ROLE_FOO"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, "ROLE_");
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("FOO"));
    }

    public void testCorrectOperationWithUserDetailsBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("rodAsUserDetails", "koala", true, true, true, true, (Collection)AuthorityUtils.NO_AUTHORITIES), (Object)"koala", new String[]{"ROLE_HELLO", "ROLE_FOOBAR"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, "");
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"rodAsUserDetails", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)auth, (Object)wrapper.getUserPrincipal());
    }

    public void testRoleIsntHeldIfAuthenticationIsNull() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, "");
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_ANY"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
    }

    public void testRolesArentHeldIfAuthenticationPrincipalIsNull() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken(null, (Object)"koala", new String[]{"ROLE_HELLO", "ROLE_FOOBAR"});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, "");
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
    }
}

