/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;

public class DefaultSessionAuthenticationStrategyTests {
    @Test
    public void newSessionShouldNotBeCreatedIfNoSessionExistsAndAlwaysCreateIsFalse() throws Exception {
        SessionFixationProtectionStrategy strategy = new SessionFixationProtectionStrategy();
        MockHttpServletRequest request = new MockHttpServletRequest();
        strategy.onAuthentication((Authentication)Mockito.mock(Authentication.class), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNull((Object)request.getSession(false));
    }

    @Test
    public void newSessionIsCreatedIfSessionAlreadyExists() throws Exception {
        SessionFixationProtectionStrategy strategy = new SessionFixationProtectionStrategy();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = request.getSession().getId();
        strategy.onAuthentication((Authentication)Mockito.mock(Authentication.class), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertFalse((boolean)sessionId.equals(request.getSession().getId()));
    }

    @Test
    public void onlySavedRequestAttributeIsMigratedIfMigrateAttributesIsFalse() throws Exception {
        SessionFixationProtectionStrategy strategy = new SessionFixationProtectionStrategy();
        strategy.setMigrateSessionAttributes(false);
        MockHttpServletRequest request = new MockHttpServletRequest();
        HttpSession session = request.getSession();
        session.setAttribute("blah", (Object)"blah");
        session.setAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY", (Object)"DefaultSavedRequest");
        strategy.onAuthentication((Authentication)Mockito.mock(Authentication.class), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNull((Object)request.getSession().getAttribute("blah"));
        Assert.assertNotNull((Object)request.getSession().getAttribute("SPRING_SECURITY_SAVED_REQUEST_KEY"));
    }

    @Test
    public void sessionIsCreatedIfAlwaysCreateTrue() throws Exception {
        SessionFixationProtectionStrategy strategy = new SessionFixationProtectionStrategy();
        strategy.setAlwaysCreateSession(true);
        MockHttpServletRequest request = new MockHttpServletRequest();
        strategy.onAuthentication((Authentication)Mockito.mock(Authentication.class), (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertNotNull((Object)request.getSession(false));
    }
}

