/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockServletContext;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.session.MockApplicationListener;
import org.springframework.web.context.support.StaticWebApplicationContext;

public class HttpSessionEventPublisherTests {
    @Test
    public void publishedEventIsReceivedbyListener() {
        HttpSessionEventPublisher publisher = new HttpSessionEventPublisher();
        StaticWebApplicationContext context = new StaticWebApplicationContext();
        MockServletContext servletContext = new MockServletContext();
        servletContext.setAttribute(StaticWebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)context);
        context.setServletContext((ServletContext)servletContext);
        context.registerSingleton("listener", MockApplicationListener.class, null);
        context.refresh();
        MockHttpSession session = new MockHttpSession((ServletContext)servletContext);
        MockApplicationListener listener = (MockApplicationListener)context.getBean("listener");
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
        publisher.sessionCreated(event);
        Assert.assertNotNull((Object)listener.getCreatedEvent());
        Assert.assertNull((Object)listener.getDestroyedEvent());
        Assert.assertEquals((Object)session, (Object)listener.getCreatedEvent().getSession());
        listener.setCreatedEvent(null);
        listener.setDestroyedEvent(null);
        publisher.sessionDestroyed(event);
        Assert.assertNotNull((Object)listener.getDestroyedEvent());
        Assert.assertNull((Object)listener.getCreatedEvent());
        Assert.assertEquals((Object)session, (Object)listener.getDestroyedEvent().getSession());
    }
}

