/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.session;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.session.SessionManagementFilter;

public class SessionManagementFilterTests {
    @After
    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    @Test
    public void newSessionShouldNotBeCreatedIfSessionExistsAndUserIsNotAuthenticated() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        MockHttpServletRequest request = new MockHttpServletRequest();
        String sessionId = request.getSession().getId();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Assert.assertEquals((Object)sessionId, (Object)request.getSession().getId());
    }

    @Test
    public void strategyIsNotInvokedIfSecurityContextAlreadyExistsForRequest() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionAuthenticationStrategy strategy = (SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class);
        Mockito.when((Object)repo.containsContext((HttpServletRequest)Matchers.any(HttpServletRequest.class))).thenReturn((Object)true);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        filter.setSessionAuthenticationStrategy(strategy);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.authenticateUser();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Mockito.verifyZeroInteractions((Object[])new Object[]{strategy});
    }

    @Test
    public void strategyIsNotInvokedIfAuthenticationIsNull() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionAuthenticationStrategy strategy = (SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        filter.setSessionAuthenticationStrategy(strategy);
        MockHttpServletRequest request = new MockHttpServletRequest();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Mockito.verifyZeroInteractions((Object[])new Object[]{strategy});
    }

    @Test
    public void strategyIsInvokedIfUserIsNewlyAuthenticated() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionAuthenticationStrategy strategy = (SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        filter.setSessionAuthenticationStrategy(strategy);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.authenticateUser();
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        ((SessionAuthenticationStrategy)Mockito.verify((Object)strategy)).onAuthentication((Authentication)Matchers.any(Authentication.class), (HttpServletRequest)Matchers.any(HttpServletRequest.class), (HttpServletResponse)Matchers.any(HttpServletResponse.class));
        filter.doFilter((ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{strategy});
    }

    @Test
    public void strategyFailureInvokesFailureHandler() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionAuthenticationStrategy strategy = (SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class);
        AuthenticationFailureHandler failureHandler = (AuthenticationFailureHandler)Mockito.mock(AuthenticationFailureHandler.class);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        filter.setAuthenticationFailureHandler(failureHandler);
        filter.setSessionAuthenticationStrategy(strategy);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        this.authenticateUser();
        SessionAuthenticationException exception = new SessionAuthenticationException("Failure");
        ((SessionAuthenticationStrategy)Mockito.doThrow((Throwable)exception).when((Object)strategy)).onAuthentication(SecurityContextHolder.getContext().getAuthentication(), (HttpServletRequest)request, (HttpServletResponse)response);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Mockito.verifyZeroInteractions((Object[])new Object[]{fc});
        ((AuthenticationFailureHandler)Mockito.verify((Object)failureHandler)).onAuthenticationFailure((HttpServletRequest)request, (HttpServletResponse)response, (AuthenticationException)exception);
    }

    @Test
    public void responseIsRedirectedToTimeoutUrlIfSetAndSessionIsInvalid() throws Exception {
        SecurityContextRepository repo = (SecurityContextRepository)Mockito.mock(SecurityContextRepository.class);
        SessionAuthenticationStrategy strategy = (SessionAuthenticationStrategy)Mockito.mock(SessionAuthenticationStrategy.class);
        SessionManagementFilter filter = new SessionManagementFilter(repo);
        filter.setSessionAuthenticationStrategy(strategy);
        filter.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy());
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestedSessionId("xxx");
        request.setRequestedSessionIdValid(false);
        MockHttpServletResponse response = new MockHttpServletResponse();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        Assert.assertNull((Object)response.getRedirectedUrl());
        request = new MockHttpServletRequest();
        request.setRequestedSessionId("xxx");
        request.setRequestedSessionIdValid(false);
        filter.setInvalidSessionUrl("/timedOut");
        FilterChain fc = (FilterChain)Mockito.mock(FilterChain.class);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, fc);
        Mockito.verifyZeroInteractions((Object[])new Object[]{fc});
        Assert.assertEquals((Object)"/timedOut", (Object)response.getRedirectedUrl());
    }

    private void authenticateUser() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new TestingAuthenticationToken((Object)"user", (Object)"pass"));
    }
}

