/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.util.ELRequestMatcher;

public class ELRequestMatcherTest {
    @Test
    public void testHasIpAddressTrue() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasIpAddress('1.1.1.1')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("1.1.1.1");
        Assert.assertTrue((boolean)requestMatcher.matches((HttpServletRequest)request));
    }

    @Test
    public void testHasIpAddressFalse() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasIpAddress('1.1.1.1')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRemoteAddr("1.1.1.2");
        Assert.assertFalse((boolean)requestMatcher.matches((HttpServletRequest)request));
    }

    @Test
    public void testHasHeaderTrue() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasHeader('User-Agent','MSIE')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", (Object)"MSIE");
        Assert.assertTrue((boolean)requestMatcher.matches((HttpServletRequest)request));
    }

    @Test
    public void testHasHeaderTwoEntries() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasHeader('User-Agent','MSIE') or hasHeader('User-Agent','Mozilla')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", (Object)"MSIE");
        Assert.assertTrue((boolean)requestMatcher.matches((HttpServletRequest)request));
        request = new MockHttpServletRequest();
        request.addHeader("User-Agent", (Object)"Mozilla");
        Assert.assertTrue((boolean)requestMatcher.matches((HttpServletRequest)request));
    }

    @Test
    public void testHasHeaderFalse() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasHeader('User-Agent','MSIE')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("User-Agent", (Object)"wrong");
        Assert.assertFalse((boolean)requestMatcher.matches((HttpServletRequest)request));
    }

    @Test
    public void testHasHeaderNull() throws Exception {
        ELRequestMatcher requestMatcher = new ELRequestMatcher("hasHeader('User-Agent','MSIE')");
        MockHttpServletRequest request = new MockHttpServletRequest();
        Assert.assertFalse((boolean)requestMatcher.matches((HttpServletRequest)request));
    }
}

