/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.util.IpAddressMatcher;

public class IpAddressMatcherTests {
    final IpAddressMatcher v6matcher = new IpAddressMatcher("fe80::21f:5bff:fe33:bd68");
    final IpAddressMatcher v4matcher = new IpAddressMatcher("192.168.1.104");
    MockHttpServletRequest ipv4Request = new MockHttpServletRequest();
    MockHttpServletRequest ipv6Request = new MockHttpServletRequest();

    @Before
    public void setup() {
        this.ipv6Request.setRemoteAddr("fe80::21f:5bff:fe33:bd68");
        this.ipv4Request.setRemoteAddr("192.168.1.104");
    }

    @Test
    public void ipv6MatcherMatchesIpv6Address() {
        Assert.assertTrue((boolean)this.v6matcher.matches((HttpServletRequest)this.ipv6Request));
    }

    @Test
    public void ipv6MatcherDoesntMatchIpv4Address() {
        Assert.assertFalse((boolean)this.v6matcher.matches((HttpServletRequest)this.ipv4Request));
    }

    @Test
    public void ipv4MatcherMatchesIpv4Address() {
        Assert.assertTrue((boolean)this.v4matcher.matches((HttpServletRequest)this.ipv4Request));
    }

    @Test
    public void ipv4SubnetMatchesCorrectly() throws Exception {
        IpAddressMatcher matcher = new IpAddressMatcher("192.168.1.0/24");
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.ipv4Request));
        matcher = new IpAddressMatcher("192.168.1.128/25");
        Assert.assertFalse((boolean)matcher.matches((HttpServletRequest)this.ipv4Request));
        this.ipv4Request.setRemoteAddr("192.168.1.159");
        Assert.assertTrue((boolean)matcher.matches((HttpServletRequest)this.ipv4Request));
    }
}

