/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.web.util.TextEscapeUtils;

public class TextEscapeUtilsTests {
    @Test
    public void charactersAreEscapedCorrectly() {
        Assert.assertEquals((Object)"&amp;&#32;a&lt;script&gt;&#34;&#39;", (Object)TextEscapeUtils.escapeEntities((String)"& a<script>\"'"));
    }

    @Test
    public void nullOrEmptyStringIsHandled() throws Exception {
        Assert.assertEquals((Object)"", (Object)TextEscapeUtils.escapeEntities((String)""));
        Assert.assertNull((Object)TextEscapeUtils.escapeEntities(null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidLowSurrogateIsDetected() throws Exception {
        TextEscapeUtils.escapeEntities((String)"abc\udcccdef");
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingLowSurrogateIsDetected() throws Exception {
        TextEscapeUtils.escapeEntities((String)"abc\ud888a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void highSurrogateAtEndOfStringIsRejected() throws Exception {
        TextEscapeUtils.escapeEntities((String)"abc\ud888");
    }

    @Test
    public void validSurrogatePairIsAccepted() throws Exception {
        Assert.assertEquals((Object)"abc&#66560;a", (Object)TextEscapeUtils.escapeEntities((String)"abc\ud801\udc00a"));
    }

    @Test
    public void undefinedSurrogatePairIsIgnored() throws Exception {
        Assert.assertEquals((Object)"abca", (Object)TextEscapeUtils.escapeEntities((String)"abc\ud888\udc00a"));
    }
}

