/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.util;

import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.ThrowableCauseExtractor;

public class ThrowableAnalyzerTests
extends TestCase {
    private Throwable[] testTrace;
    private ThrowableAnalyzer standardAnalyzer;
    private ThrowableAnalyzer nonstandardAnalyzer;

    protected void setUp() throws Exception {
        super.setUp();
        this.testTrace = new Throwable[7];
        this.testTrace[6] = new IllegalArgumentException("Test_6");
        this.testTrace[5] = new Throwable("Test_5", this.testTrace[6]);
        this.testTrace[4] = new InvocationTargetException(this.testTrace[5], "Test_4");
        this.testTrace[3] = new Exception("Test_3", this.testTrace[4]);
        this.testTrace[2] = new NonStandardException("Test_2", this.testTrace[3]);
        this.testTrace[1] = new RuntimeException("Test_1", this.testTrace[2]);
        this.testTrace[0] = new Exception("Test_0", this.testTrace[1]);
        this.standardAnalyzer = new ThrowableAnalyzer();
        this.nonstandardAnalyzer = new ThrowableAnalyzer(){

            protected void initExtractorMap() {
                super.initExtractorMap();
                this.registerExtractor(NonStandardException.class, new NonStandardExceptionCauseExtractor());
            }
        };
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterExtractorWithInvalidExtractor() {
        try {
            new ThrowableAnalyzer(){

                protected void initExtractorMap() {
                    super.registerExtractor(Exception.class, null);
                }
            };
            ThrowableAnalyzerTests.fail((String)"IllegalArgumentExpected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetRegisteredTypes() {
        Class[] registeredTypes = this.nonstandardAnalyzer.getRegisteredTypes();
        for (int i = 0; i < registeredTypes.length; ++i) {
            Class clazz = registeredTypes[i];
            for (int j = 0; j < i; ++j) {
                Class prevClazz = registeredTypes[j];
                ThrowableAnalyzerTests.assertFalse((String)("Unexpected order of registered classes: " + prevClazz + " is assignable from " + clazz), (boolean)prevClazz.isAssignableFrom(clazz));
            }
        }
    }

    public void testDetermineCauseChainWithNoExtractors() {
        ThrowableAnalyzer analyzer = new ThrowableAnalyzer(){

            protected void initExtractorMap() {
            }
        };
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected number of registered types", (int)0, (int)analyzer.getRegisteredTypes().length);
        Throwable t = this.testTrace[0];
        Throwable[] chain = analyzer.determineCauseChain(t);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected chain size", (int)1, (int)chain.length);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected chain entry", (Object)t, (Object)chain[0]);
    }

    public void testDetermineCauseChainWithDefaultExtractors() {
        ThrowableAnalyzer analyzer = this.standardAnalyzer;
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected number of registered types", (int)2, (int)analyzer.getRegisteredTypes().length);
        Throwable[] chain = analyzer.determineCauseChain(this.testTrace[0]);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected chain size", (int)3, (int)chain.length);
        for (int i = 0; i < 3; ++i) {
            ThrowableAnalyzerTests.assertEquals((String)("Unexpected chain entry: " + i), (Object)this.testTrace[i], (Object)chain[i]);
        }
    }

    public void testDetermineCauseChainWithCustomExtractors() {
        ThrowableAnalyzer analyzer = this.nonstandardAnalyzer;
        Throwable[] chain = analyzer.determineCauseChain(this.testTrace[0]);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected chain size", (int)this.testTrace.length, (int)chain.length);
        for (int i = 0; i < chain.length; ++i) {
            ThrowableAnalyzerTests.assertEquals((String)("Unexpected chain entry: " + i), (Object)this.testTrace[i], (Object)chain[i]);
        }
    }

    public void testGetFirstThrowableOfTypeWithSuccess1() {
        ThrowableAnalyzer analyzer = this.nonstandardAnalyzer;
        Throwable[] chain = analyzer.determineCauseChain(this.testTrace[0]);
        Throwable result = analyzer.getFirstThrowableOfType(Exception.class, chain);
        ThrowableAnalyzerTests.assertNotNull((String)"null not expected", (Object)result);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected throwable found", (Object)this.testTrace[0], (Object)result);
    }

    public void testGetFirstThrowableOfTypeWithSuccess2() {
        ThrowableAnalyzer analyzer = this.nonstandardAnalyzer;
        Throwable[] chain = analyzer.determineCauseChain(this.testTrace[0]);
        Throwable result = analyzer.getFirstThrowableOfType(NonStandardException.class, chain);
        ThrowableAnalyzerTests.assertNotNull((String)"null not expected", (Object)result);
        ThrowableAnalyzerTests.assertEquals((String)"Unexpected throwable found", (Object)this.testTrace[2], (Object)result);
    }

    public void testGetFirstThrowableOfTypeWithFailure() {
        ThrowableAnalyzer analyzer = this.nonstandardAnalyzer;
        Throwable[] chain = analyzer.determineCauseChain(this.testTrace[0]);
        Throwable result = analyzer.getFirstThrowableOfType(IllegalStateException.class, chain);
        ThrowableAnalyzerTests.assertNull((String)"null expected", (Object)result);
    }

    public void testVerifyThrowableHierarchyWithExactType() {
        IllegalStateException throwable = new IllegalStateException("Test");
        ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, IllegalStateException.class);
    }

    public void testVerifyThrowableHierarchyWithCompatibleType() {
        IllegalStateException throwable = new IllegalStateException("Test");
        ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, Exception.class);
    }

    public void testVerifyThrowableHierarchyWithNull() {
        try {
            ThrowableAnalyzer.verifyThrowableHierarchy(null, Throwable.class);
            ThrowableAnalyzerTests.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testVerifyThrowableHierarchyWithNonmatchingType() {
        IllegalStateException throwable = new IllegalStateException("Test");
        try {
            ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, InvocationTargetException.class);
            ThrowableAnalyzerTests.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static final class NonStandardExceptionCauseExtractor
    implements ThrowableCauseExtractor {
        public Throwable extractCause(Throwable throwable) {
            ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, NonStandardException.class);
            return ((NonStandardException)throwable).resolveCause();
        }
    }

    public static final class NonStandardException
    extends Exception {
        private Throwable cause;

        public NonStandardException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }

        public Throwable resolveCause() {
            return this.cause;
        }
    }
}

