/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http.support;

import java.util.Optional;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.springframework.data.gemfire.config.annotation.support.CacheTypeAwareRegionFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.util.StringUtils;

public class SessionCacheTypeAwareRegionFactoryBean<K, V>
extends CacheTypeAwareRegionFactoryBean<K, V> {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_CLIENT_REGION_SHORTCUT;
    protected static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_SERVER_REGION_SHORTCUT;
    protected static final String DEFAULT_POOL_NAME = "gemfirePool";
    protected static final String DEFAULT_SESSION_REGION_NAME = "ClusteredSpringSessions";
    private String regionName;

    public ClientRegionShortcut getClientRegionShortcut() {
        return Optional.ofNullable(super.getClientRegionShortcut()).orElse(DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    protected Optional<String> getPoolName() {
        return Optional.of(super.getPoolName().orElse(DEFAULT_POOL_NAME));
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    protected String getRegionName() {
        return Optional.ofNullable(this.regionName).filter(StringUtils::hasText).orElse(DEFAULT_SESSION_REGION_NAME);
    }

    public String resolveRegionName() {
        return this.getRegionName();
    }

    public RegionShortcut getServerRegionShortcut() {
        return Optional.ofNullable(super.getServerRegionShortcut()).orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }
}

