/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.serialization.SessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.support.WirableDataSerializer;
import org.springframework.stereotype.Component;

@Component
public class DataSerializerSessionSerializerAdapter<T extends Session>
extends WirableDataSerializer<T> {
    private SessionSerializer<T, DataInput, DataOutput> sessionSerializer;

    public DataSerializerSessionSerializerAdapter() {
        this.autowire();
    }

    @Override
    public int getId() {
        return 195832748;
    }

    @Autowired
    @Qualifier(value="SessionSerializerRegisteredBeanAlias")
    public final void setSessionSerializer(SessionSerializer<T, DataInput, DataOutput> sessionSerializer) {
        this.sessionSerializer = Optional.ofNullable(sessionSerializer).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"SessionSerializer is required", (Object[])new Object[0]));
    }

    public SessionSerializer<T, DataInput, DataOutput> getSessionSerializer() {
        return Optional.ofNullable(this.sessionSerializer).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"SessionSerializer was not properly configured", (Object[])new Object[0]));
    }

    @Override
    public Class<?>[] getSupportedClasses() {
        return (Class[])ArrayUtils.asArray((Object[])new Class[]{AbstractGemFireOperationsSessionRepository.GemFireSession.class, AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes.class, AbstractGemFireOperationsSessionRepository.DeltaCapableGemFireSession.class, AbstractGemFireOperationsSessionRepository.DeltaCapableGemFireSessionAttributes.class});
    }

    @Override
    public void serialize(T session, DataOutput out) {
        this.getSessionSerializer().serialize(session, out);
    }

    @Override
    public T deserialize(DataInput in) {
        return (T)((Session)this.getSessionSerializer().deserialize(in));
    }

    static {
        DataSerializerSessionSerializerAdapter.register(DataSerializerSessionSerializerAdapter.class);
    }
}

