/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.pdx.provider;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxWriter;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.serialization.pdx.AbstractPdxSerializableSessionSerializer;
import org.springframework.session.data.gemfire.support.AbstractSession;

public class PdxSerializableSessionSerializer
extends AbstractPdxSerializableSessionSerializer<AbstractGemFireOperationsSessionRepository.GemFireSession> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(AbstractGemFireOperationsSessionRepository.GemFireSession session, PdxWriter writer) {
        AbstractGemFireOperationsSessionRepository.GemFireSession gemFireSession = session;
        synchronized (gemFireSession) {
            writer.writeString("id", session.getId());
            writer.writeLong("creationTime", session.getCreationTime().toEpochMilli());
            writer.writeLong("lastAccessedTime", session.getLastAccessedTime().toEpochMilli());
            writer.writeLong("maxInactiveIntervalInSeconds", session.getMaxInactiveInterval().getSeconds());
            writer.writeString("principalName", session.getPrincipalName());
            writer.writeObject("attributes", this.newMap((Map)session.getAttributes()));
            writer.markIdentityField("id");
        }
    }

    protected <K, V> Map<K, V> newMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    @Override
    public AbstractGemFireOperationsSessionRepository.GemFireSession deserialize(final PdxReader reader) {
        AbstractGemFireOperationsSessionRepository.GemFireSession session = AbstractGemFireOperationsSessionRepository.GemFireSession.from(new AbstractSession(){

            @Override
            public String getId() {
                return reader.readString("id");
            }

            @Override
            public Instant getCreationTime() {
                return Instant.ofEpochMilli(reader.readLong("creationTime"));
            }

            @Override
            public Instant getLastAccessedTime() {
                return Instant.ofEpochMilli(reader.readLong("lastAccessedTime"));
            }

            @Override
            public Duration getMaxInactiveInterval() {
                return Duration.ofSeconds(reader.readLong("maxInactiveIntervalInSeconds"));
            }

            @Override
            public Set<String> getAttributeNames() {
                return Collections.emptySet();
            }
        });
        session.setPrincipalName(reader.readString("principalName"));
        ((AbstractGemFireOperationsSessionRepository.GemFireSessionAttributes)session.getAttributes()).from((Map)reader.readObject("attributes"));
        return session;
    }

    @Override
    public boolean canSerialize(Class<?> type) {
        return Optional.ofNullable(type).map(AbstractGemFireOperationsSessionRepository.GemFireSession.class::isAssignableFrom).orElse(false);
    }
}

