/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.pdx.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;

public class ComposablePdxSerializer
implements PdxSerializer,
Iterable<PdxSerializer> {
    private final List<PdxSerializer> pdxSerializers;

    public static PdxSerializer compose(PdxSerializer ... pdxSerializers) {
        return ComposablePdxSerializer.compose(Arrays.asList(ArrayUtils.nullSafeArray((Object[])pdxSerializers, PdxSerializer.class)));
    }

    public static PdxSerializer compose(Iterable<PdxSerializer> pdxSerializers) {
        List<PdxSerializer> pdxSerializerList = StreamSupport.stream(CollectionUtils.nullSafeIterable(pdxSerializers).spliterator(), false).filter(Objects::nonNull).collect(Collectors.toList());
        return pdxSerializerList.isEmpty() ? null : (pdxSerializerList.size() == 1 ? (PdxSerializer)pdxSerializerList.get(0) : new ComposablePdxSerializer(pdxSerializerList));
    }

    private ComposablePdxSerializer(List<PdxSerializer> pdxSerializers) {
        this.pdxSerializers = Optional.ofNullable(pdxSerializers).map(it -> Collections.unmodifiableList(pdxSerializers)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException((String)"PdxSerializers [%s] are required", (Object[])new Object[]{pdxSerializers}));
    }

    @Override
    public Iterator<PdxSerializer> iterator() {
        return this.pdxSerializers.iterator();
    }

    public boolean toData(Object obj, PdxWriter out) {
        for (PdxSerializer pdxSerializer : this) {
            if (!pdxSerializer.toData(obj, out)) continue;
            return true;
        }
        return false;
    }

    public Object fromData(Class<?> type, PdxReader in) {
        for (PdxSerializer pdxSerializer : this) {
            Object obj = pdxSerializer.fromData(type, in);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }
}

