/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.expiration.support;

import java.time.Duration;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.expiration.support.IdleTimeoutSessionExpirationPolicy;
import org.springframework.util.Assert;

public class FixedTimeoutSessionExpirationPolicy
extends IdleTimeoutSessionExpirationPolicy {
    private final Duration fixedTimeout;

    public FixedTimeoutSessionExpirationPolicy(@NonNull Duration fixedTimeout) {
        super(null);
        Assert.notNull((Object)fixedTimeout, (String)"Fixed expiration timeout is required");
        this.fixedTimeout = fixedTimeout;
    }

    protected Duration getFixedTimeout() {
        return this.fixedTimeout;
    }

    @Override
    public Optional<Duration> determineExpirationTimeout(@NonNull Session session) {
        Duration fixedExpirationTimeout;
        Optional<Duration> idleTimeout = super.determineExpirationTimeout(session);
        return idleTimeout.filter(arg_0 -> FixedTimeoutSessionExpirationPolicy.lambda$determineExpirationTimeout$0(fixedExpirationTimeout = this.getFixedTimeout().minus(this.computeTimeSinceCreation(session)), arg_0)).isPresent() ? Optional.empty() : Optional.of(fixedExpirationTimeout);
    }

    private Duration computeTimeSinceCreation(@NonNull Session session) {
        long timeSinceCreation = Math.max(System.currentTimeMillis() - session.getCreationTime().toEpochMilli(), 0L);
        return Duration.ofMillis(timeSinceCreation);
    }

    private static /* synthetic */ boolean lambda$determineExpirationTimeout$0(Duration fixedExpirationTimeout, Duration it) {
        return it.compareTo(fixedExpirationTimeout) <= 0;
    }
}

