/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.serialization.data.support;

import java.util.Optional;
import java.util.Properties;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.GemFireCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.session.data.gemfire.serialization.data.provider.DataSerializableSessionSerializer;
import org.springframework.session.data.gemfire.support.GemFireOperationsSessionRepositorySupport;

public class DataSerializableSessionSerializerInitializer
implements Declarable {
    private volatile GemFireCache gemfireCache;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static DataSerializableSessionSerializerInitializer of(@Nullable GemFireCache gemfireCache) {
        return new DataSerializableSessionSerializerInitializer(gemfireCache);
    }

    public DataSerializableSessionSerializerInitializer() {
        this(null);
    }

    public DataSerializableSessionSerializerInitializer(@Nullable GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    protected Optional<GemFireCache> getGemFireCache() {
        return Optional.ofNullable(this.gemfireCache);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void initialize(Cache cache, Properties parameters) {
        this.gemfireCache = cache;
        this.doInitialization();
    }

    public void doInitialization() {
        this.resolveGemFireCache();
        this.registerDataSerializableSessionSerializer();
        this.configureUseDataSerialization();
    }

    protected GemFireCache resolveGemFireCache() {
        return this.getGemFireCache().orElseGet(CacheFactory::getAnyInstance);
    }

    protected void registerDataSerializableSessionSerializer() {
        DataSerializableSessionSerializer.register();
    }

    protected void configureUseDataSerialization() {
        InitializingGemFireOperationsSessionRepository.INSTANCE.setUseDataSerialization(true);
    }

    static final class InitializingGemFireOperationsSessionRepository
    extends GemFireOperationsSessionRepositorySupport {
        static final InitializingGemFireOperationsSessionRepository INSTANCE = new InitializingGemFireOperationsSessionRepository();

        InitializingGemFireOperationsSessionRepository() {
        }

        boolean isDataSerializationConfigured() {
            return InitializingGemFireOperationsSessionRepository.isUsingDataSerialization();
        }
    }
}

