/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate3;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

public abstract class HibernateAccessor
implements InitializingBean,
BeanFactoryAware {
    public static final int FLUSH_NEVER = 0;
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EAGER = 2;
    public static final int FLUSH_COMMIT = 3;
    public static final int FLUSH_ALWAYS = 4;
    private static final Constants constants = new Constants(class$org$springframework$orm$hibernate3$HibernateAccessor == null ? (class$org$springframework$orm$hibernate3$HibernateAccessor = HibernateAccessor.class$("org.springframework.orm.hibernate3.HibernateAccessor")) : class$org$springframework$orm$hibernate3$HibernateAccessor);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;
    private Object entityInterceptor;
    private SQLExceptionTranslator jdbcExceptionTranslator;
    private int flushMode = 1;
    private String[] filterNames;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$orm$hibernate3$HibernateAccessor;
    static /* synthetic */ Class class$org$hibernate$Interceptor;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setEntityInterceptorBeanName(String entityInterceptorBeanName) {
        this.entityInterceptor = entityInterceptorBeanName;
    }

    public void setEntityInterceptor(Interceptor entityInterceptor) {
        this.entityInterceptor = entityInterceptor;
    }

    public Interceptor getEntityInterceptor() throws IllegalStateException, BeansException {
        if (this.entityInterceptor instanceof String) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("Cannot get entity interceptor via bean name if no bean factory set");
            }
            return (Interceptor)this.beanFactory.getBean((String)this.entityInterceptor, class$org$hibernate$Interceptor == null ? (class$org$hibernate$Interceptor = HibernateAccessor.class$("org.hibernate.Interceptor")) : class$org$hibernate$Interceptor);
        }
        return (Interceptor)this.entityInterceptor;
    }

    public void setJdbcExceptionTranslator(SQLExceptionTranslator jdbcExceptionTranslator) {
        this.jdbcExceptionTranslator = jdbcExceptionTranslator;
    }

    public SQLExceptionTranslator getJdbcExceptionTranslator() {
        if (this.jdbcExceptionTranslator == null) {
            this.jdbcExceptionTranslator = SessionFactoryUtils.newJdbcExceptionTranslator(this.getSessionFactory());
        }
        return this.jdbcExceptionTranslator;
    }

    public void setFlushModeName(String constantName) {
        this.setFlushMode(constants.asNumber(constantName).intValue());
    }

    public void setFlushMode(int flushMode) {
        this.flushMode = flushMode;
    }

    public int getFlushMode() {
        return this.flushMode;
    }

    public void setFilterName(String filter) {
        this.filterNames = new String[]{filter};
    }

    public void setFilterNames(String[] filterNames) {
        this.filterNames = filterNames;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.getSessionFactory() == null) {
            throw new IllegalArgumentException("sessionFactory is required");
        }
    }

    protected FlushMode applyFlushMode(Session session, boolean existingTransaction) {
        if (this.getFlushMode() == 0) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (!previousFlushMode.equals(FlushMode.NEVER)) {
                    session.setFlushMode(FlushMode.NEVER);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.NEVER);
            }
        } else if (this.getFlushMode() == 2) {
            FlushMode previousFlushMode;
            if (existingTransaction && !(previousFlushMode = session.getFlushMode()).equals(FlushMode.AUTO)) {
                session.setFlushMode(FlushMode.AUTO);
                return previousFlushMode;
            }
        } else if (this.getFlushMode() == 3) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (previousFlushMode.equals(FlushMode.AUTO) || previousFlushMode.equals(FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.COMMIT);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.COMMIT);
            }
        } else if (this.getFlushMode() == 4) {
            if (existingTransaction) {
                FlushMode previousFlushMode = session.getFlushMode();
                if (!previousFlushMode.equals(FlushMode.ALWAYS)) {
                    session.setFlushMode(FlushMode.ALWAYS);
                    return previousFlushMode;
                }
            } else {
                session.setFlushMode(FlushMode.ALWAYS);
            }
        }
        return null;
    }

    protected void flushIfNecessary(Session session, boolean existingTransaction) throws HibernateException {
        if (this.getFlushMode() == 2 || !existingTransaction && this.getFlushMode() != 0) {
            this.logger.debug((Object)"Eagerly flushing Hibernate session");
            session.flush();
        }
    }

    public DataAccessException convertHibernateAccessException(HibernateException ex) {
        if (ex instanceof JDBCException) {
            return this.convertJdbcAccessException((JDBCException)ex);
        }
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }

    protected DataAccessException convertJdbcAccessException(JDBCException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation: " + ex.getMessage(), ex.getSQL(), ex.getSQLException());
    }

    protected DataAccessException convertJdbcAccessException(SQLException ex) {
        return this.getJdbcExceptionTranslator().translate("Hibernate operation", null, ex);
    }

    protected void enableFilters(Session session) {
        String[] filterNames = this.getFilterNames();
        if (filterNames != null) {
            for (int i = 0; i < filterNames.length; ++i) {
                session.enableFilter(filterNames[i]);
            }
        }
    }

    protected void disableFilters(Session session) {
        String[] filterNames = this.getFilterNames();
        if (filterNames != null) {
            for (int i = 0; i < filterNames.length; ++i) {
                session.disableFilter(filterNames[i]);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

