/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.jdbc;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.jdbc.MergedSqlConfig;
import org.springframework.test.context.jdbc.Sql;
import org.springframework.test.context.jdbc.SqlConfig;
import org.springframework.test.context.jdbc.SqlGroup;
import org.springframework.test.context.jdbc.SqlMergeMode;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.TestContextTransactionUtils;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SqlScriptsTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(SqlScriptsTestExecutionListener.class);

    @Override
    public final int getOrder() {
        return 5000;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) {
        this.executeSqlScripts(testContext, Sql.ExecutionPhase.BEFORE_TEST_METHOD);
    }

    @Override
    public void afterTestMethod(TestContext testContext) {
        this.executeSqlScripts(testContext, Sql.ExecutionPhase.AFTER_TEST_METHOD);
    }

    private void executeSqlScripts(TestContext testContext, Sql.ExecutionPhase executionPhase) {
        Method testMethod = testContext.getTestMethod();
        Class<?> testClass = testContext.getTestClass();
        if (this.mergeSqlAnnotations(testContext)) {
            this.executeSqlScripts(this.getSqlAnnotationsFor(testClass), testContext, executionPhase, true);
            this.executeSqlScripts(this.getSqlAnnotationsFor(testMethod), testContext, executionPhase, false);
        } else {
            Set<Sql> methodLevelSqlAnnotations = this.getSqlAnnotationsFor(testMethod);
            if (!methodLevelSqlAnnotations.isEmpty()) {
                this.executeSqlScripts(methodLevelSqlAnnotations, testContext, executionPhase, false);
            } else {
                this.executeSqlScripts(this.getSqlAnnotationsFor(testClass), testContext, executionPhase, true);
            }
        }
    }

    private boolean mergeSqlAnnotations(TestContext testContext) {
        SqlMergeMode sqlMergeMode = this.getSqlMergeModeFor(testContext.getTestMethod());
        if (sqlMergeMode == null) {
            sqlMergeMode = this.getSqlMergeModeFor(testContext.getTestClass());
        }
        return sqlMergeMode != null && sqlMergeMode.value() == SqlMergeMode.MergeMode.MERGE;
    }

    @Nullable
    private SqlMergeMode getSqlMergeModeFor(AnnotatedElement element) {
        return (SqlMergeMode)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)element, SqlMergeMode.class);
    }

    private Set<Sql> getSqlAnnotationsFor(AnnotatedElement element) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations((AnnotatedElement)element, Sql.class, SqlGroup.class);
    }

    private void executeSqlScripts(Set<Sql> sqlAnnotations, TestContext testContext, Sql.ExecutionPhase executionPhase, boolean classLevel) {
        sqlAnnotations.forEach(sql -> this.executeSqlScripts((Sql)sql, executionPhase, testContext, classLevel));
    }

    private void executeSqlScripts(Sql sql, Sql.ExecutionPhase executionPhase, TestContext testContext, boolean classLevel) {
        boolean newTxRequired;
        if (executionPhase != sql.executionPhase()) {
            return;
        }
        MergedSqlConfig mergedSqlConfig = new MergedSqlConfig(sql.config(), testContext.getTestClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Processing %s for execution phase [%s] and test context %s.", new Object[]{mergedSqlConfig, executionPhase, testContext}));
        }
        String[] scripts = this.getScripts(sql, testContext, classLevel);
        scripts = TestContextResourceUtils.convertToClasspathResourcePaths(testContext.getTestClass(), scripts);
        List<Resource> scriptResources = TestContextResourceUtils.convertToResourceList((ResourceLoader)testContext.getApplicationContext(), scripts);
        for (String stmt : sql.statements()) {
            if (!StringUtils.hasText((String)stmt)) continue;
            stmt = stmt.trim();
            scriptResources.add((Resource)new ByteArrayResource(stmt.getBytes(), "from inlined SQL statement: " + stmt));
        }
        ResourceDatabasePopulator populator = this.createDatabasePopulator(mergedSqlConfig);
        populator.setScripts(scriptResources.toArray(new Resource[0]));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing SQL scripts: " + ObjectUtils.nullSafeToString(scriptResources)));
        }
        String dsName = mergedSqlConfig.getDataSource();
        String tmName = mergedSqlConfig.getTransactionManager();
        DataSource dataSource = TestContextTransactionUtils.retrieveDataSource(testContext, dsName);
        PlatformTransactionManager txMgr = TestContextTransactionUtils.retrieveTransactionManager(testContext, tmName);
        boolean bl = newTxRequired = mergedSqlConfig.getTransactionMode() == SqlConfig.TransactionMode.ISOLATED;
        if (txMgr == null) {
            Assert.state((!newTxRequired ? 1 : 0) != 0, () -> String.format("Failed to execute SQL scripts for test context %s: cannot execute SQL scripts using Transaction Mode [%s] without a PlatformTransactionManager.", new Object[]{testContext, SqlConfig.TransactionMode.ISOLATED}));
            Assert.state((dataSource != null ? 1 : 0) != 0, () -> String.format("Failed to execute SQL scripts for test context %s: supply at least a DataSource or PlatformTransactionManager.", testContext));
            populator.execute(dataSource);
        } else {
            DataSource dataSourceFromTxMgr = this.getDataSourceFromTransactionManager(txMgr);
            if (dataSource != null && dataSourceFromTxMgr != null && !dataSource.equals(dataSourceFromTxMgr)) {
                throw new IllegalStateException(String.format("Failed to execute SQL scripts for test context %s: the configured DataSource [%s] (named '%s') is not the one associated with transaction manager [%s] (named '%s').", testContext, dataSource.getClass().getName(), dsName, txMgr.getClass().getName(), tmName));
            }
            if (dataSource == null) {
                dataSource = dataSourceFromTxMgr;
                Assert.state((dataSource != null ? 1 : 0) != 0, () -> String.format("Failed to execute SQL scripts for test context %s: could not obtain DataSource from transaction manager [%s] (named '%s').", testContext, txMgr.getClass().getName(), tmName));
            }
            DataSource finalDataSource = dataSource;
            int propagation = newTxRequired ? 3 : 0;
            TransactionAttribute txAttr = TestContextTransactionUtils.createDelegatingTransactionAttribute(testContext, (TransactionAttribute)new DefaultTransactionAttribute(propagation));
            new TransactionTemplate(txMgr, (TransactionDefinition)txAttr).executeWithoutResult(s -> populator.execute(finalDataSource));
        }
    }

    @NonNull
    private ResourceDatabasePopulator createDatabasePopulator(MergedSqlConfig mergedSqlConfig) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setSqlScriptEncoding(mergedSqlConfig.getEncoding());
        populator.setSeparator(mergedSqlConfig.getSeparator());
        populator.setCommentPrefixes(mergedSqlConfig.getCommentPrefixes());
        populator.setBlockCommentStartDelimiter(mergedSqlConfig.getBlockCommentStartDelimiter());
        populator.setBlockCommentEndDelimiter(mergedSqlConfig.getBlockCommentEndDelimiter());
        populator.setContinueOnError(mergedSqlConfig.getErrorMode() == SqlConfig.ErrorMode.CONTINUE_ON_ERROR);
        populator.setIgnoreFailedDrops(mergedSqlConfig.getErrorMode() == SqlConfig.ErrorMode.IGNORE_FAILED_DROPS);
        return populator;
    }

    @Nullable
    private DataSource getDataSourceFromTransactionManager(PlatformTransactionManager transactionManager) {
        try {
            Method getDataSourceMethod = transactionManager.getClass().getMethod("getDataSource", new Class[0]);
            Object obj = ReflectionUtils.invokeMethod((Method)getDataSourceMethod, (Object)transactionManager);
            if (obj instanceof DataSource) {
                return (DataSource)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String[] getScripts(Sql sql, TestContext testContext, boolean classLevel) {
        Object[] scripts = sql.scripts();
        if (ObjectUtils.isEmpty((Object[])scripts) && ObjectUtils.isEmpty((Object[])sql.statements())) {
            scripts = new String[]{this.detectDefaultScript(testContext, classLevel)};
        }
        return scripts;
    }

    private String detectDefaultScript(TestContext testContext, boolean classLevel) {
        Class<?> clazz = testContext.getTestClass();
        Method method = testContext.getTestMethod();
        String elementType = classLevel ? "class" : "method";
        String elementName = classLevel ? clazz.getName() : method.toString();
        String resourcePath = ClassUtils.convertClassNameToResourcePath((String)clazz.getName());
        if (!classLevel) {
            resourcePath = resourcePath + "." + method.getName();
        }
        resourcePath = resourcePath + ".sql";
        String prefixedResourcePath = "classpath:" + resourcePath;
        ClassPathResource classPathResource = new ClassPathResource(resourcePath);
        if (classPathResource.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Detected default SQL script \"%s\" for test %s [%s]", prefixedResourcePath, elementType, elementName));
            }
            return prefixedResourcePath;
        }
        String msg = String.format("Could not detect default SQL script for test %s [%s]: %s does not exist. Either declare statements or scripts via @Sql or make the default SQL script available.", elementType, elementName, classPathResource);
        logger.error((Object)msg);
        throw new IllegalStateException(msg);
    }
}

