/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.event;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.test.context.event.ApplicationEvents;

class DefaultApplicationEvents
implements ApplicationEvents {
    private final List<ApplicationEvent> events = new ArrayList<ApplicationEvent>();

    DefaultApplicationEvents() {
    }

    void addEvent(ApplicationEvent event) {
        this.events.add(event);
    }

    @Override
    public Stream<ApplicationEvent> stream() {
        return this.events.stream();
    }

    @Override
    public <T> Stream<T> stream(Class<T> type) {
        return this.events.stream().map(this::unwrapPayloadEvent).filter(type::isInstance).map(type::cast);
    }

    @Override
    public void clear() {
        this.events.clear();
    }

    private Object unwrapPayloadEvent(Object source) {
        Object object;
        if (source instanceof PayloadApplicationEvent) {
            PayloadApplicationEvent payloadApplicationEvent = (PayloadApplicationEvent)source;
            object = payloadApplicationEvent.getPayload();
        } else {
            object = source;
        }
        return object;
    }
}

