/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.statemachine.cluster;

import java.util.HashMap;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.zookeeper.leader.LeaderInitiator;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.zookeeper.ZookeeperStateMachineEnsemble;

public class LeaderZookeeperStateMachineEnsemble<S, E>
extends ZookeeperStateMachineEnsemble<S, E> {
    private final Map<StateMachine<S, E>, InitiatorHolder> holders = new HashMap<StateMachine<S, E>, InitiatorHolder>();
    private final CuratorFramework curatorClient;
    private final String basePath;
    private StateMachine<S, E> leader;

    public LeaderZookeeperStateMachineEnsemble(CuratorFramework curatorClient, String basePath) {
        super(curatorClient, basePath);
        this.curatorClient = curatorClient;
        this.basePath = basePath;
    }

    public LeaderZookeeperStateMachineEnsemble(CuratorFramework curatorClient, String basePath, boolean cleanState, int logSize) {
        super(curatorClient, basePath, cleanState, logSize);
        this.curatorClient = curatorClient;
        this.basePath = basePath;
    }

    public void join(StateMachine<S, E> stateMachine) {
        super.join(stateMachine);
        StateMachineCandidate candidate = new StateMachineCandidate(stateMachine);
        LeaderInitiator initiator = new LeaderInitiator(this.curatorClient, (Candidate)candidate, this.basePath + "/leader");
        initiator.start();
        this.holders.put(stateMachine, new InitiatorHolder(candidate, initiator));
    }

    public void leave(StateMachine<S, E> stateMachine) {
        super.leave(stateMachine);
        InitiatorHolder holder = this.holders.get(stateMachine);
        holder.candidate.yieldLeadership();
        holder.initiator.stop();
        this.holders.remove(stateMachine);
    }

    public StateMachine<S, E> getLeader() {
        return this.leader;
    }

    private class StateMachineCandidate
    extends DefaultCandidate {
        final StateMachine<S, E> stateMachine;

        public StateMachineCandidate(StateMachine<S, E> stateMachine) {
            this.stateMachine = stateMachine;
        }

        public void onGranted(Context ctx) {
            super.onGranted(ctx);
            LeaderZookeeperStateMachineEnsemble.this.leader = this.stateMachine;
            LeaderZookeeperStateMachineEnsemble.this.notifyGranted(this.stateMachine);
        }

        public void onRevoked(Context ctx) {
            super.onRevoked(ctx);
            LeaderZookeeperStateMachineEnsemble.this.leader = null;
            LeaderZookeeperStateMachineEnsemble.this.notifyRevoked(this.stateMachine);
        }
    }

    private class InitiatorHolder {
        final StateMachineCandidate candidate;
        final LeaderInitiator initiator;

        public InitiatorHolder(StateMachineCandidate candidate, LeaderInitiator initiator) {
            this.candidate = candidate;
            this.initiator = initiator;
        }
    }
}

