/*
 * Decompiled with CFR 0.152.
 */
package demo.web;

import demo.web.StateMachineConfig;
import demo.web.StateMachineEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.annotation.MessageExceptionHandler;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineException;
import org.springframework.statemachine.ensemble.EnsembleListener;
import org.springframework.statemachine.ensemble.StateMachineEnsemble;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import reactor.core.publisher.Mono;

@Controller
public class StateMachineController {
    private final Log log = LogFactory.getLog(StateMachineController.class);
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    @Autowired
    private StateMachine<StateMachineConfig.States, StateMachineConfig.Events> stateMachine;
    @Autowired
    private StateMachineEnsemble<StateMachineConfig.States, StateMachineConfig.Events> stateMachineEnsemble;

    @PostConstruct
    public void setup() {
        this.stateMachine.addStateListener((StateMachineListener)new /* Unavailable Anonymous Inner Class!! */);
        this.stateMachineEnsemble.addEnsembleListener((EnsembleListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    @SubscribeMapping(value={"/sm.uuid"})
    public String retrieveUuid() {
        return this.stateMachine.getUuid().toString();
    }

    @SubscribeMapping(value={"/sm.states"})
    public Collection<StateMachineEvent> retrieveStates() {
        ArrayList<StateMachineEvent> list = new ArrayList<StateMachineEvent>();
        for (StateMachineConfig.States state : this.stateMachine.getState().getIds()) {
            list.add(new StateMachineEvent(state.toString()));
        }
        return list;
    }

    @SubscribeMapping(value={"/sm.variables"})
    public Map<Object, Object> retrieveVariables() {
        return this.stateMachine.getExtendedState().getVariables();
    }

    @RequestMapping(value={"/event"})
    @ResponseStatus(value=HttpStatus.OK)
    public void sendEvent(@RequestParam(value="id") StateMachineConfig.Events id, @RequestParam(value="testVariable", required=false) String testVariable) {
        this.log.info((Object)("Got request to send event " + id + " testVariable " + testVariable));
        Message message = MessageBuilder.withPayload((Object)id).setHeader("testVariable", (Object)testVariable).build();
        this.stateMachine.sendEvent(Mono.just((Object)message)).subscribe();
    }

    @RequestMapping(value={"/join"})
    @ResponseStatus(value=HttpStatus.OK)
    public void joinEnsemble() {
        this.stateMachineEnsemble.join(this.stateMachine);
    }

    @RequestMapping(value={"/leave"})
    @ResponseStatus(value=HttpStatus.OK)
    public void leaveEnsemble() {
        this.stateMachineEnsemble.leave(this.stateMachine);
    }

    @RequestMapping(value={"/states"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Collection<StateMachineConfig.States> getStates() {
        return this.stateMachine.getState().getIds();
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<Object, Object> getStatus() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("hasStateMachineError", this.stateMachine.hasStateMachineError());
        map.put("isComplete", this.stateMachine.isComplete());
        map.put("extendedStateVariables", this.stateMachine.getExtendedState().getVariables());
        return map;
    }

    @MessageExceptionHandler
    @SendToUser(value={"/queue/errors"}, broadcast=false)
    public String handleStateMachineError(StateMachineException e) {
        return e.getMessage();
    }

    static /* synthetic */ SimpMessagingTemplate access$000(StateMachineController x0) {
        return x0.simpMessagingTemplate;
    }

    static /* synthetic */ StateMachine access$100(StateMachineController x0) {
        return x0.stateMachine;
    }
}

