[Video.js homepage](https://videojs.com)

<h1>Video.js Documentation</h1>

There are two categories of docs: [Guides](./guides/) and [API docs](./api/). Guides explain general topics and use cases (e.g. setup). API docs are automatically generated from the codebase and give specific details about functions, properties, and events.

(Corrections and additions welcome)

## Guides

### Getting Started

* [Setup](./guides/setup.md) - Check out the [5 second setup](https://videojs.com/#section5) if you're just getting started. The setup documentation gives a deeper view of the additional methods you can use to trigger the player setup.

* [Options](./guides/options.md) - There are a number of options that can be used to change how the player behaves, starting with the HTML5 media options like autoplay and preload, and expanding to Video.JS specific options.

* [Tracks](./guides/tracks.md) - Text Tracks are used to display subtitles and captions, and add a menu for navigating between chapters in a video.

### Customizing

* [API](./guides/api.md) - The Video.js API allows you to control the video through javascript or trigger event listeners, whether the video is playing through HTML5, flash, or another playback technology.

* [Skins](./guides/skins.md) - You can change the look of the player across playback technologies just by editing a CSS file. The skins documentation gives you a intro to how the HTML and CSS of the default skin is put together.

* [Tech](./guides/tech.md) - A 'playback technology' is the term we're using to represent HTML5 video, Flash, and other video plugins, as well as other players like the YouTube player. Basically anything that has a unique API to audio or video. Additional playback technologies can be added relatively easily.

* [Plugins](./guides/plugins.md) - You can package up interesting Video.js customizations and reuse them elsewhere. Find out how to build your own plugin or use one created by someone else.

### Resources

* [Glossary](./guides/glossary.md) - Some helpful definitions.

## API Docs
- The most relevant API doc is the [player API doc](./api/vjs.Player.md).
- [Full list of API Docs](./api/)
