/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.SqlCrudEngine;
import org.sqlproc.engine.SqlEngine;
import org.sqlproc.engine.SqlEngineException;
import org.sqlproc.engine.SqlEngineFactory;
import org.sqlproc.engine.SqlFilesLoader;
import org.sqlproc.engine.SqlMonitorFactory;
import org.sqlproc.engine.SqlProcedureEngine;
import org.sqlproc.engine.SqlProcessorLoader;
import org.sqlproc.engine.SqlQueryEngine;
import org.sqlproc.engine.plugin.SqlPluginFactory;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlTypeFactory;
import org.sqlproc.engine.validation.SqlValidatorFactory;

public class SqlSimpleFactory
implements SqlEngineFactory {
    private static final String LINESEP = System.getProperty("line.separator");
    private List<String> metaFilesNames = new ArrayList<String>();
    private StringBuilder metaStatements;
    private SqlTypeFactory typeFactory;
    protected SqlPluginFactory pluginFactory;
    private String filter;
    private SqlMonitorFactory monitorFactory;
    private List<SqlInternalType> customTypes;
    private String[] onlyStatements;
    private boolean jdbc;
    private SqlProcessorLoader processorLoader;
    private SqlValidatorFactory validatorFactory;
    private boolean lazyInit;

    public SqlSimpleFactory() {
    }

    public SqlSimpleFactory(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init() {
        if (this.processorLoader == null) {
            SqlSimpleFactory sqlSimpleFactory = this;
            synchronized (sqlSimpleFactory) {
                if (this.processorLoader == null && (this.metaStatements != null || this.metaFilesNames != null && !this.metaFilesNames.isEmpty())) {
                    if (this.metaStatements == null) {
                        this.metaStatements = SqlFilesLoader.getStatements(this.getClass(), this.metaFilesNames.toArray(new String[0]));
                    }
                    if (this.jdbc) {
                        this.metaStatements.append(LINESEP).append("JDBC(BOPT)=true;");
                    }
                    this.processorLoader = new SqlProcessorLoader(this.metaStatements, this.typeFactory, this.pluginFactory, this.filter, this.monitorFactory, this.validatorFactory, this.customTypes, this.lazyInit, this.onlyStatements);
                }
            }
        }
    }

    public void init0() {
        if (this.getLoader() == null) {
            this.init();
        }
    }

    @Override
    public SqlQueryEngine getQueryEngine(String name) {
        this.init0();
        return this.getLoader().getQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getCrudEngine(String name) {
        this.init0();
        return this.getLoader().getCrudEngine(name);
    }

    @Override
    public SqlProcedureEngine getProcedureEngine(String name) {
        this.init0();
        return this.getLoader().getProcedureEngine(name);
    }

    @Override
    public SqlQueryEngine getStaticQueryEngine(String name) {
        this.init0();
        return this.getLoader().getStaticQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getStaticCrudEngine(String name) {
        this.init0();
        return this.getLoader().getStaticCrudEngine(name);
    }

    @Override
    public SqlProcedureEngine getStaticProcedureEngine(String name) {
        this.init0();
        return this.getLoader().getStaticProcedureEngine(name);
    }

    @Override
    public SqlQueryEngine getCheckedQueryEngine(String name) throws SqlEngineException {
        this.init0();
        return this.getLoader().getCheckedQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getCheckedCrudEngine(String name) {
        this.init0();
        return this.getLoader().getCheckedCrudEngine(name);
    }

    @Override
    public SqlProcedureEngine getCheckedProcedureEngine(String name) {
        this.init0();
        return this.getLoader().getCheckedProcedureEngine(name);
    }

    @Override
    public SqlQueryEngine getCheckedStaticQueryEngine(String name) throws SqlEngineException {
        this.init0();
        return this.getLoader().getCheckedStaticQueryEngine(name);
    }

    @Override
    public SqlCrudEngine getCheckedStaticCrudEngine(String name) {
        this.init0();
        return this.getLoader().getCheckedStaticCrudEngine(name);
    }

    @Override
    public SqlProcedureEngine getCheckedStaticProcedureEngine(String name) {
        this.init0();
        return this.getLoader().getCheckedStaticProcedureEngine(name);
    }

    @Override
    public SqlQueryEngine getDynamicQueryEngine(String name, String sqlStatement) throws SqlEngineException {
        this.init0();
        return this.getLoader().getDynamicQueryEngine(name, sqlStatement);
    }

    @Override
    public SqlCrudEngine getDynamicCrudEngine(String name, String sqlStatement) {
        this.init0();
        return this.getLoader().getDynamicCrudEngine(name, sqlStatement);
    }

    @Override
    public SqlProcedureEngine getDynamicProcedureEngine(String name, String sqlStatement) {
        this.init0();
        return this.getLoader().getDynamicProcedureEngine(name, sqlStatement);
    }

    public List<String> getMetaFilesNames() {
        return this.metaFilesNames;
    }

    public void setMetaFilesNames(List<String> metaFilesNames) {
        this.metaFilesNames = metaFilesNames;
    }

    public void setMetaFilesNames(String ... metaFilesNames) {
        this.metaFilesNames = new ArrayList<String>();
        Collections.addAll(this.metaFilesNames, metaFilesNames);
    }

    public StringBuilder getMetaStatements() {
        return this.metaStatements;
    }

    public void setMetaStatements(StringBuilder metaStatements) {
        this.metaStatements = metaStatements;
    }

    public SqlTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public void setTypeFactory(SqlTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public SqlPluginFactory getPluginFactory() {
        return this.pluginFactory;
    }

    public void setPluginFactory(SqlPluginFactory pluginFactory) {
        this.pluginFactory = pluginFactory;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public SqlMonitorFactory getMonitorFactory() {
        return this.monitorFactory;
    }

    public void setMonitorFactory(SqlMonitorFactory monitorFactory) {
        this.monitorFactory = monitorFactory;
    }

    public List<SqlInternalType> getCustomTypes() {
        return this.customTypes;
    }

    public void setCustomTypes(List<SqlInternalType> customTypes) {
        this.customTypes = customTypes;
    }

    public void setCustomTypes(SqlInternalType ... customTypes) {
        this.customTypes = new ArrayList<SqlInternalType>();
        Collections.addAll(this.customTypes, customTypes);
    }

    public void addCustomType(SqlInternalType customType) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList<SqlInternalType>();
        }
        this.customTypes.add(customType);
    }

    public String[] getOnlyStatements() {
        return this.onlyStatements;
    }

    public void setOnlyStatements(String[] selectQueries) {
        this.onlyStatements = selectQueries != null ? Arrays.copyOf(selectQueries, selectQueries.length) : null;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    @Override
    public boolean isLazyInit() {
        return this.lazyInit;
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public SqlEngineFactory getLoader() {
        return this.processorLoader;
    }

    public SqlValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public void setValidatorFactory(SqlValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    @Override
    public Collection<String> getNames() {
        return this.getLoader().getNames();
    }

    @Override
    public Collection<String> getDynamicNames() {
        return this.getLoader().getDynamicNames();
    }

    @Override
    public Map<String, SqlEngine> getEngines() {
        return this.getLoader().getEngines();
    }

    @Override
    public Map<String, SqlEngine> getDynamicEngines() {
        return this.getLoader().getDynamicEngines();
    }
}

