/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.impl;

import java.util.List;
import java.util.Map;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlInputValue;
import org.sqlproc.engine.impl.SqlMetaConst;
import org.sqlproc.engine.impl.SqlProcessContext;
import org.sqlproc.engine.impl.SqlType;
import org.sqlproc.engine.impl.SqlUtils;

class SqlMetaOperator
extends SqlMetaConst {
    boolean dynamicInputValue;

    public SqlMetaOperator(SqlInputValue.Code caseConversion, boolean not, SqlType type) {
        super(caseConversion, not, type);
    }

    public SqlMetaOperator(SqlInputValue.Code caseConversion, boolean not) {
        super(caseConversion, not);
    }

    public SqlMetaOperator(SqlInputValue.Code caseConversion) {
        super(caseConversion);
    }

    public SqlMetaOperator(boolean dynamicInputValue, List<String> elements) {
        super(SqlInputValue.Code.NONE);
        this.dynamicInputValue = dynamicInputValue;
        this.setElements(elements);
    }

    @Override
    Object getInputValues(SqlProcessContext ctx) {
        if (this.dynamicInputValue) {
            return ctx.getDynamicInputValues();
        }
        return ctx.getStaticInputValues();
    }

    @Override
    String getDefaultData() {
        return "=";
    }

    @Override
    Class<?> getFieldType(SqlProcessContext ctx, Class<?> attributeType, String attributeName) {
        if (attributeName.indexOf("@") >= 0 || attributeName.indexOf("?") >= 0) {
            return String.class;
        }
        return BeanUtils.getFieldType(attributeType, attributeName);
    }

    @Override
    Object getProperty(SqlProcessContext ctx, Object obj, String item) {
        Object o;
        Object result;
        String prefix = null;
        String suffix = null;
        String name = null;
        int ix = item.indexOf("?");
        if (ix >= 0) {
            prefix = item.substring(0, ix);
            suffix = item.substring(ix + 1);
            name = prefix + suffix;
        } else {
            ix = item.indexOf("@");
            if (ix >= 0) {
                prefix = item.substring(0, ix);
                suffix = ctx.getFeature(item.substring(ix + 1));
                name = prefix + suffix;
            } else {
                name = item;
            }
        }
        Object object = result = BeanUtils.checkProperty(obj, name) ? BeanUtils.getProperty(obj, name) : null;
        if (result != null || prefix == null || suffix == null) {
            return result;
        }
        Object object2 = o = BeanUtils.checkProperty(obj, suffix = SqlUtils.firstLowerCase(suffix)) ? BeanUtils.getProperty(obj, suffix) : null;
        if (o == null || !(o instanceof Map)) {
            suffix = ctx.getFeature("OPERATOR_ATTRIBUTE_IN_MAP");
            Object object3 = o = BeanUtils.checkProperty(obj, suffix) ? BeanUtils.getProperty(obj, suffix) : null;
            if (o == null || !(o instanceof Map)) {
                return null;
            }
        }
        Map map = (Map)o;
        return map.get(prefix);
    }

    @Override
    String getData(SqlProcessContext ctx, Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }
}

