/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlBooleanType;

public class JdbcBooleanType
extends SqlBooleanType
implements JdbcSqlType {
    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Object getProviderSqlNullType() {
        return -7;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return rs.getBoolean(Integer.parseInt(columnLabel)) ? Boolean.TRUE : Boolean.FALSE;
        }
        return rs.getBoolean(columnLabel) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setBoolean(index, (Boolean)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Boolean result = cs.getBoolean(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

