/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sqlproc.engine.type.SqlInternalType;
import org.sqlproc.engine.type.SqlMetaType;
import org.sqlproc.engine.type.SqlTypeFactory;

public class SqlComposedTypeFactory
implements SqlTypeFactory {
    private Map<Class<?>, SqlMetaType> classToTypeMap = new HashMap();
    private Map<String, SqlMetaType> metaToTypeMap = new HashMap<String, SqlMetaType>();
    private SqlTypeFactory typeFactory;

    public SqlComposedTypeFactory(SqlTypeFactory typeFactory) {
        this(typeFactory, null);
    }

    public SqlComposedTypeFactory(SqlTypeFactory typeFactory, List<SqlInternalType> customTypes) {
        this.typeFactory = typeFactory;
        if (customTypes != null && !customTypes.isEmpty()) {
            for (SqlInternalType type : customTypes) {
                for (Class<?> classType : type.getClassTypes()) {
                    this.classToTypeMap.put(classType, type);
                }
                for (String metaType : type.getMetaTypes()) {
                    this.metaToTypeMap.put(metaType.toUpperCase(), type);
                }
            }
        }
    }

    @Override
    public SqlMetaType getDefaultType() {
        return this.typeFactory.getDefaultType();
    }

    @Override
    public SqlMetaType getEnumIntegerType() {
        return this.typeFactory.getEnumIntegerType();
    }

    @Override
    public SqlMetaType getEnumStringType() {
        return this.typeFactory.getEnumStringType();
    }

    @Override
    public SqlMetaType getIdentityType() {
        return this.typeFactory.getIdentityType();
    }

    @Override
    public SqlMetaType[] getAllTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlMetaType getMetaType(Class<?> clazz) {
        SqlMetaType metaType = this.classToTypeMap.get(clazz);
        if (metaType == null) {
            metaType = this.typeFactory.getMetaType(clazz);
        }
        return metaType;
    }

    @Override
    public SqlMetaType getMetaType(String name) {
        SqlMetaType metaType = this.metaToTypeMap.get(name.toUpperCase());
        if (metaType == null) {
            metaType = this.typeFactory.getMetaType(name);
        }
        return metaType;
    }
}

