/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.impl.BeanUtils;
import org.sqlproc.engine.impl.SqlUtils;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlProviderType;

public abstract class SqlEnumIntegerType
extends SqlProviderType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[0];
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"EINTEGER", "EINT"};
    }

    @Override
    public void addScalar(SqlQuery query, String dbName, Class<?> attributeType) {
        query.addScalar(dbName, this.getProviderSqlType());
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setResult " + this.getMetaTypes()[0] + ": resultInstance=" + resultInstance + ", attributeName=" + attributeName + ", resultValue=" + resultValue);
        }
        Class<?> attributeType = BeanUtils.getFieldType(resultInstance.getClass(), attributeName);
        Method m = BeanUtils.getSetter(resultInstance, attributeName, attributeType);
        if (m != null) {
            Object enumInstance = SqlUtils.getValueToEnum(runtimeCtx, attributeType, resultValue);
            BeanUtils.simpleInvokeMethod(m, resultInstance, enumInstance);
        } else if (ingoreError) {
            this.logger.error("There's no getter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        } else {
            throw new SqlRuntimeException("There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, Class<?> inputType, boolean ingoreError) throws SqlRuntimeException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(">>> setParameter " + this.getMetaTypes()[0] + ": paramName=" + paramName + ", inputValue=" + inputValue + ", inputType=" + inputType);
        }
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlNullType());
            return;
        } else if (!inputValue.getClass().isEnum()) {
            if (!(inputValue instanceof Collection)) {
                if (inputValue instanceof OutValueSetter) {
                    query.setParameter(paramName, inputValue, this.getProviderSqlType());
                    return;
                } else {
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect integer based enum " + inputValue + " for " + paramName);
                    this.logger.error("Incorrect integer based enum " + inputValue + " for " + paramName);
                }
                return;
            } else {
                ArrayList<Integer> vals = new ArrayList<Integer>();
                for (Object val : (Collection)inputValue) {
                    if (!val.getClass().isEnum()) {
                        if (!ingoreError) throw new SqlRuntimeException("Incorrect integer based enum item " + val + " for " + paramName);
                        this.logger.error("Incorrect integer based enum item " + val + " for " + paramName);
                        continue;
                    }
                    Object o = SqlUtils.getEnumToValue(runtimeCtx, val);
                    if (o != null && o instanceof Integer) {
                        vals.add((Integer)o);
                        continue;
                    }
                    if (!ingoreError) throw new SqlRuntimeException("Incorrect integer based enum item value " + o + " for " + paramName);
                    this.logger.error("Incorrect integer based enum item value " + o + " for " + paramName);
                }
                query.setParameterList(paramName, vals.toArray());
            }
            return;
        } else {
            Object o = SqlUtils.getEnumToValue(runtimeCtx, inputValue);
            if (o != null && o instanceof Integer) {
                query.setParameter(paramName, (Integer)o, this.getProviderSqlType());
                return;
            } else {
                if (!ingoreError) throw new SqlRuntimeException("Incorrect integer based enum value " + o + " for " + paramName);
                this.logger.error("Incorrect integer based enum value " + o + " for " + paramName);
            }
        }
    }
}

