/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlByteArrayType;

public class JdbcByteArrayType
extends SqlByteArrayType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{byte[].class};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return -3;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return rs.getBytes(Integer.parseInt(columnLabel));
        }
        return rs.getBytes(columnLabel);
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        byte[] bytes = (byte[])value;
        st.setBytes(index, bytes);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        byte[] result = cs.getBytes(index);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

