/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlShortType;

public class JdbcShortType
extends SqlShortType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Short.class, Short.TYPE};
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return 5;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        if (Character.isDigit(columnLabel.charAt(0))) {
            return new Short(rs.getShort(Integer.parseInt(columnLabel)));
        }
        return new Short(rs.getShort(columnLabel));
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        st.setShort(index, (Short)value);
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Short result = new Short(cs.getShort(index));
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }
}

