/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.jdbc.type;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.sqlproc.engine.SqlProcessorException;
import org.sqlproc.engine.jdbc.type.JdbcSqlType;
import org.sqlproc.engine.type.SqlTextType;

public class JdbcTextType
extends SqlTextType
implements JdbcSqlType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[0];
    }

    @Override
    public Object getProviderSqlType() {
        return this;
    }

    @Override
    public Integer getDatabaseSqlType() {
        return -1;
    }

    @Override
    public Object get(ResultSet rs, String columnLabel) throws SQLException {
        Reader charReader = Character.isDigit(columnLabel.charAt(0)) ? rs.getCharacterStream(Integer.parseInt(columnLabel)) : rs.getCharacterStream(columnLabel);
        if (charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = charReader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, amountRead);
            }
        }
        catch (IOException e) {
            throw new SqlProcessorException("IOException occurred reading text", e);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e) {
                throw new SqlProcessorException("IOException occurred closing stream", e);
            }
        }
        return sb.toString();
    }

    @Override
    public void set(PreparedStatement st, int index, Object value) throws SQLException {
        String str = (String)value;
        st.setCharacterStream(index, (Reader)new StringReader((String)value), str.length());
    }

    @Override
    public Object get(CallableStatement cs, int index) throws SQLException {
        Reader charReader = cs.getCharacterStream(index);
        if (cs.wasNull() || charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = charReader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, amountRead);
            }
        }
        catch (IOException e) {
            throw new SqlProcessorException("IOException occurred reading text", e);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e) {
                throw new SqlProcessorException("IOException occurred closing stream", e);
            }
        }
        return sb.toString();
    }
}

