/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDLLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<String> ddls;

    public DDLLoader(String fileName, Class<?> loaderClass) {
        this.ddls = this.load(fileName, loaderClass);
    }

    public static List<String> getDDLs(Class<?> loaderClass, String fileName) {
        DDLLoader loader = new DDLLoader(fileName, loaderClass);
        return loader.getDdls();
    }

    public DDLLoader(List<String> fileNames, Class<?> loaderClass) {
        this.ddls = new ArrayList<String>();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String fileName : fileNames) {
            List<String> _ddls = this.load(fileName, loaderClass);
            this.ddls.addAll(_ddls);
        }
    }

    public static List<String> getDDLs(Class<?> loaderClass, String ... fileNames) {
        ArrayList<String> propsNames = new ArrayList<String>();
        Collections.addAll(propsNames, fileNames);
        DDLLoader loader = new DDLLoader(propsNames, loaderClass);
        return loader.getDdls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> load(String fileName, Class<?> loaderClass) {
        ArrayList<String> arrayList;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">> load, fileName=" + fileName + ", loaderClass=" + loaderClass);
        }
        ArrayList<String> ddls = new ArrayList<String>();
        InputStream is = null;
        BufferedReader bfr = null;
        try {
            String line;
            String ddlFile = "/" + fileName;
            is = loaderClass.getResourceAsStream(ddlFile);
            if (is == null) {
                ddlFile = fileName;
                is = loaderClass.getResourceAsStream(ddlFile);
            }
            if (is == null) {
                try {
                    ddlFile = "/" + fileName;
                    is = new FileInputStream(ddlFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (is == null) {
                try {
                    ddlFile = System.getProperty("user.home") + ddlFile;
                    is = new FileInputStream(ddlFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (is == null) {
                arrayList = ddls;
                return arrayList;
            }
            bfr = new BufferedReader(new InputStreamReader(is));
            StringBuilder completeLine = new StringBuilder("");
            boolean inFuncOrProc = false;
            while ((line = bfr.readLine()) != null) {
                if (line.startsWith("--")) continue;
                if (line.trim().length() > 0) {
                    completeLine.append(" ").append(line);
                }
                if (!inFuncOrProc && line.trim().toUpperCase().startsWith("CREATE") && (line.indexOf("FUNCTION") >= 0 || line.indexOf("PROCEDURE") >= 0)) {
                    inFuncOrProc = true;
                }
                boolean finishedDdl = false;
                if (!inFuncOrProc && line.trim().endsWith(";")) {
                    finishedDdl = true;
                } else if (line.trim().length() == 0) {
                    finishedDdl = true;
                }
                if (!finishedDdl) continue;
                if (completeLine.length() > 0) {
                    ddls.add(completeLine.toString());
                }
                completeLine = new StringBuilder("");
                inFuncOrProc = false;
            }
            if (completeLine.length() > 0) {
                ddls.add(completeLine.toString());
            }
            ArrayList<String> arrayList2 = ddls;
            return arrayList2;
        }
        catch (Exception ex) {
            this.logger.error("I cant read " + fileName, (Throwable)ex);
            arrayList = ddls;
            return arrayList;
        }
        finally {
            if (bfr != null) {
                try {
                    bfr.close();
                }
                catch (Exception exception) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("<< load, properties=" + ddls);
            }
        }
    }

    public List<String> getDdls() {
        return this.ddls;
    }
}

