/*
 * Decompiled with CFR 0.152.
 */
package org.sqlproc.engine.type;

import java.sql.Timestamp;
import java.time.Instant;
import org.sqlproc.engine.SqlQuery;
import org.sqlproc.engine.SqlRuntimeContext;
import org.sqlproc.engine.SqlRuntimeException;
import org.sqlproc.engine.type.OutValueSetter;
import org.sqlproc.engine.type.SqlDefaultType;

public abstract class SqlInstantType
extends SqlDefaultType {
    @Override
    public Class<?>[] getClassTypes() {
        return new Class[]{Instant.class};
    }

    @Override
    public String[] getMetaTypes() {
        return new String[]{"INSTANT"};
    }

    @Override
    public void setResult(SqlRuntimeContext runtimeCtx, Object resultInstance, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        this.setResultEntryLog(this.logger, this, runtimeCtx, resultInstance, attributeName, resultValue, ingoreError);
        if (resultValue == null) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, null, Instant.class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            return;
        }
        if (resultValue instanceof Timestamp) {
            if (runtimeCtx.simpleSetAttribute(resultInstance, attributeName, ((Timestamp)resultValue).toInstant(), Instant.class)) {
                return;
            }
            this.error(this.logger, ingoreError, "There's no setter for " + attributeName + " in " + resultInstance + ", META type is " + this.getMetaTypes()[0]);
            return;
        }
        this.error(this.logger, ingoreError, "Incorrect instant " + resultValue + " for " + attributeName + " in " + resultInstance);
    }

    @Override
    public Object getResult(SqlRuntimeContext runtimeCtx, String attributeName, Object resultValue, boolean ingoreError) throws SqlRuntimeException {
        if (resultValue == null) {
            return null;
        }
        if (resultValue instanceof Timestamp) {
            return ((Timestamp)resultValue).toInstant();
        }
        return resultValue;
    }

    @Override
    public void setParameter(SqlRuntimeContext runtimeCtx, SqlQuery query, String paramName, Object inputValue, boolean ingoreError, Class<?> ... inputTypes) throws SqlRuntimeException {
        this.setParameterEntryLog(this.logger, this, runtimeCtx, query, paramName, inputValue, ingoreError, inputTypes);
        if (inputValue == null) {
            query.setParameter(paramName, inputValue, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof Instant) {
            Timestamp value = Timestamp.from((Instant)inputValue);
            query.setParameter(paramName, value, this.getProviderSqlType(), new Class[0]);
        } else if (inputValue instanceof OutValueSetter) {
            final OutValueSetter outValueSetter = (OutValueSetter)inputValue;
            OutValueSetter _outValueSetter = new OutValueSetter(){

                @Override
                public Object setOutValue(Object outValue) {
                    if (outValue == null) {
                        return outValueSetter.setOutValue(null);
                    }
                    if (outValue instanceof Timestamp) {
                        Instant result = ((Timestamp)outValue).toInstant();
                        return outValueSetter.setOutValue(result);
                    }
                    throw new RuntimeException("Incorret function output value for instant");
                }
            };
            query.setParameter(paramName, _outValueSetter, this.getProviderSqlType(), new Class[0]);
        } else {
            this.error(this.logger, ingoreError, "Incorrect instant " + inputValue + " for " + paramName);
        }
    }
}

