/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.model;

import java.io.Serializable;
import java.util.Map;
import org.srplib.contract.Assert;
import org.srplib.model.AbstractValueModel;
import org.srplib.model.ContextDependentValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapValueAdapter<K, V>
extends AbstractValueModel<V>
implements ContextDependentValueModel<Map<K, V>, V>,
Serializable {
    private K key;
    private Map<K, V> map;

    public static <K, V> MapValueAdapter<K, V> create(Map<K, V> map, K key) {
        return new MapValueAdapter<K, V>(map, key);
    }

    public MapValueAdapter(Class<V> valueClass, K key) {
        super(valueClass);
        this.key = key;
    }

    public MapValueAdapter(Map<K, V> map, K key) {
        this((Class)null, key);
        this.map = map;
    }

    public void setValue(V value) {
        Assert.checkNotNull(this.map, (String)"Context object isn't set!", (Object[])new Object[0]);
        this.map.put(this.key, value);
    }

    public V getValue() {
        Assert.checkNotNull(this.map, (String)"Context object isn't set!", (Object[])new Object[0]);
        return this.map.get(this.key);
    }

    public void setContext(Map<K, V> context) {
        this.map = context;
    }
}

