/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator;

import java.util.HashMap;
import java.util.Map;
import org.stjs.generator.BridgeClass;
import org.stjs.generator.ClassResolver;
import org.stjs.generator.ClassWithJavascript;
import org.stjs.generator.STJSClass;
import org.stjs.generator.STJSRuntimeException;
import org.stjs.generator.utils.ClassUtils;

public class DefaultClassResolver
implements ClassResolver {
    private final ClassLoader classLoader;
    private final Map<String, ClassWithJavascript> cache = new HashMap<String, ClassWithJavascript>();

    public DefaultClassResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassWithJavascript resolve(String className) {
        ClassWithJavascript clazz = this.cache.get(className);
        if (clazz == null && (clazz = this.doResolve(className)) != null) {
            this.cache.put(className, clazz);
        }
        return clazz;
    }

    @Override
    public Class<?> resolveJavaClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new STJSRuntimeException(e);
        }
    }

    protected String getParentClassName(String className) {
        String parentClassName = className;
        int pos = parentClassName.indexOf(36);
        if (pos > 0 && parentClassName.charAt(pos - 1) != '.') {
            parentClassName = parentClassName.substring(0, pos);
        }
        return parentClassName;
    }

    protected ClassWithJavascript doResolve(String className) {
        String parentClassName = this.getParentClassName(className);
        Class<?> clazz = this.resolveJavaClass(parentClassName);
        if (ClassUtils.isBridge(this.classLoader, clazz)) {
            return new BridgeClass(this, clazz);
        }
        return new STJSClass((ClassResolver)this, this.classLoader, clazz);
    }
}

