/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeWrapper;

public class ClassGlobalForbidInnerCheck
implements CheckContributor<ClassTree> {
    private void checkMember(Tree member, GenerationContext<Void> context) {
        if (member instanceof ClassTree) {
            context.addError(member, "You cannot define an inner type inside a @GlobalScope class. Please define it outside this class.");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (!tw.isGlobal()) {
            return null;
        }
        for (Tree tree2 : tree.getMembers()) {
            this.checkMember(tree2, context);
        }
        return null;
    }
}

