/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.ClassTree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.GeneratorConstants;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.writer.JavascriptKeywords;

public class ClassNamespaceCheck
implements CheckContributor<ClassTree> {
    @Override
    public Void visit(CheckVisitor visitor, ClassTree tree, GenerationContext<Void> context) {
        String namespace = context.getCurrentWrapper().getNamespace();
        if (!namespace.isEmpty()) {
            String[] identifiers;
            if (!GeneratorConstants.NAMESPACE_PATTERN.matcher(namespace).matches()) {
                context.addError(tree, "The namespace must be in the form <identifier>[.<identifier>]..");
            }
            for (String identifier : identifiers = namespace.split("\\.")) {
                if (!JavascriptKeywords.isReservedWord(identifier)) continue;
                context.addError(tree, "Identifier \"" + identifier + "\" cannot be used as part of a namespace, " + "because it is a javascript keyword or a javascript reserved word");
            }
        }
        return null;
    }
}

