/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.declaration;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.InternalUtils;
import org.stjs.generator.javac.TreeWrapper;
import org.stjs.generator.writer.MemberWriters;

public class MethodVarArgParamCheck
implements CheckContributor<MethodTree> {
    private void checkVarArg(MethodTree tree, VariableTree param, GenerationContext<Void> context) {
        if (!param.getName().toString().equals("arguments")) {
            context.addError(param, "You can only have a vararg parameter that has to be called 'arguments'");
        }
        if (tree.getParameters().size() != 1) {
            context.addError(tree, "You can only have a vararg parameter that has to be called 'arguments'");
        }
    }

    @Override
    public Void visit(CheckVisitor visitor, MethodTree tree, GenerationContext<Void> context) {
        TreeWrapper tw = context.getCurrentWrapper();
        if (MemberWriters.shouldSkip(tw)) {
            return null;
        }
        if (tw.isNative()) {
            return null;
        }
        for (VariableTree variableTree : tree.getParameters()) {
            if (!InternalUtils.isVarArg(variableTree)) continue;
            this.checkVarArg(tree, variableTree, context);
        }
        return null;
    }
}

