/*
 * Decompiled with CFR 0.152.
 */
package org.stjs.generator.check.expression;

import com.sun.source.tree.IdentifierTree;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import org.stjs.generator.GenerationContext;
import org.stjs.generator.check.CheckContributor;
import org.stjs.generator.check.CheckVisitor;
import org.stjs.generator.javac.TreeUtils;
import org.stjs.javascript.annotation.ServerSide;

public class IdentifierAccessServerSideCheck
implements CheckContributor<IdentifierTree> {
    private boolean isRegularField(Element fieldElement, IdentifierTree tree) {
        if (fieldElement == null || fieldElement.getKind() != ElementKind.FIELD) {
            return false;
        }
        return !"this".equals(tree.getName().toString()) && !"super".equals(tree.getName().toString());
    }

    @Override
    public Void visit(CheckVisitor visitor, IdentifierTree tree, GenerationContext<Void> context) {
        Element fieldElement = TreeUtils.elementFromUse(tree);
        if (!this.isRegularField(fieldElement, tree)) {
            return null;
        }
        if (fieldElement.getAnnotation(ServerSide.class) != null) {
            context.addError(tree, "You cannot access fields annotated with @ServerSide in a client code");
        }
        return null;
    }
}

